/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.util.Locale;

public abstract class Platform {
    private static final Locale LOCALE = Locale.ENGLISH;
    private final OS os;

    private Platform(OS os2) {
        this.os = os2;
        try {
            String versionString = System.getProperty("java.version");
            if (versionString != null) {
                String[] v = versionString.split("\\.");
                Integer.valueOf(v[1]).intValue();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public static CPU getCPU() {
        return ArchHolder.cpu;
    }

    public abstract int longSize();

    public final int addressSize() {
        return ArchHolder.cpu.dataModel;
    }

    private static boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.startsWith(s2) || s1.toUpperCase(LOCALE).startsWith(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).startsWith(s2.toLowerCase(LOCALE));
    }

    static /* synthetic */ OS access$100() {
        String string = System.getProperty("os.name").split(" ")[0];
        if (Platform.startsWithIgnoreCase(string, "mac") || Platform.startsWithIgnoreCase(string, "darwin")) {
            return OS.DARWIN;
        }
        if (Platform.startsWithIgnoreCase(string, "linux")) {
            return OS.LINUX;
        }
        if (Platform.startsWithIgnoreCase(string, "sunos") || Platform.startsWithIgnoreCase(string, "solaris")) {
            return OS.SOLARIS;
        }
        if (Platform.startsWithIgnoreCase(string, "aix")) {
            return OS.AIX;
        }
        if (Platform.startsWithIgnoreCase(string, "openbsd")) {
            return OS.OPENBSD;
        }
        if (Platform.startsWithIgnoreCase(string, "freebsd")) {
            return OS.FREEBSD;
        }
        if (Platform.startsWithIgnoreCase(string, "windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    static /* synthetic */ Platform access$200(OS x0) {
        OS oS = x0;
        switch (oS) {
            case DARWIN: {
                return new Darwin();
            }
            case WINDOWS: {
                return new Windows();
            }
        }
        OS oS2 = oS;
        return new Default(oS2);
    }

    /* synthetic */ Platform(OS x0, byte by) {
        this(x0);
    }

    static final class Windows
    extends Platform {
        public Windows() {
            super(OS.WINDOWS, (byte)0);
        }

        public final int longSize() {
            return 32;
        }
    }

    static final class Darwin
    extends Platform {
        public Darwin() {
            super(OS.DARWIN, (byte)0);
        }

        public final int longSize() {
            return ArchHolder.cpu.dataModel;
        }
    }

    static final class Default
    extends Platform {
        public Default(OS os2) {
            super(os2, (byte)0);
        }

        public final int longSize() {
            return ArchHolder.cpu.dataModel;
        }
    }

    static final class ArchHolder {
        public static final CPU cpu = ArchHolder.determineCPU();

        private static CPU determineCPU() {
            String archString = null;
            try {
                archString = Foreign.getInstance().getArch();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            if (archString == null || "unknown".equals(archString)) {
                archString = System.getProperty("os.arch", "unknown");
            }
            if ("x86".equalsIgnoreCase(archString) || "i386".equalsIgnoreCase(archString) || "i86pc".equalsIgnoreCase(archString)) {
                return CPU.I386;
            }
            if ("x86_64".equalsIgnoreCase(archString) || "amd64".equalsIgnoreCase(archString)) {
                return CPU.X86_64;
            }
            if ("ppc".equalsIgnoreCase(archString) || "powerpc".equalsIgnoreCase(archString)) {
                return CPU.PPC;
            }
            if ("ppc64".equalsIgnoreCase(archString) || "powerpc64".equalsIgnoreCase(archString)) {
                return CPU.PPC64;
            }
            if ("s390".equalsIgnoreCase(archString) || "s390x".equalsIgnoreCase(archString)) {
                return CPU.S390X;
            }
            if ("arm".equalsIgnoreCase(archString)) {
                return CPU.ARM;
            }
            for (CPU cpu : CPU.values()) {
                if (!cpu.name().equalsIgnoreCase(archString)) continue;
                return cpu;
            }
            return CPU.UNKNOWN;
        }
    }

    static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$200(Platform.access$100());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CPU
    extends Enum<CPU> {
        public static final /* enum */ CPU I386 = new CPU(32);
        public static final /* enum */ CPU X86_64 = new CPU(64);
        public static final /* enum */ CPU PPC = new CPU(32);
        public static final /* enum */ CPU PPC64 = new CPU(64);
        private static /* enum */ CPU SPARC = new CPU(32);
        private static /* enum */ CPU SPARCV9 = new CPU(64);
        public static final /* enum */ CPU S390X = new CPU(64);
        public static final /* enum */ CPU ARM = new CPU(32);
        public static final /* enum */ CPU UNKNOWN = new CPU(64);
        public final int dataModel;
        public final long addressMask;
        private static final /* synthetic */ CPU[] $VALUES;

        public static CPU[] values() {
            return (CPU[])$VALUES.clone();
        }

        private CPU(int dataModel) {
            this.dataModel = dataModel;
            this.addressMask = dataModel == 32 ? 0xFFFFFFFFL : -1L;
        }

        public final String toString() {
            return this.name().toLowerCase(LOCALE);
        }

        static {
            $VALUES = new CPU[]{I386, X86_64, PPC, PPC64, SPARC, SPARCV9, S390X, ARM, UNKNOWN};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OS
    extends Enum<OS> {
        public static final /* enum */ OS DARWIN = new OS();
        public static final /* enum */ OS FREEBSD = new OS();
        private static /* enum */ OS NETBSD = new OS();
        public static final /* enum */ OS OPENBSD = new OS();
        public static final /* enum */ OS LINUX = new OS();
        public static final /* enum */ OS SOLARIS = new OS();
        public static final /* enum */ OS WINDOWS = new OS();
        public static final /* enum */ OS AIX = new OS();
        private static /* enum */ OS ZLINUX = new OS();
        public static final /* enum */ OS UNKNOWN = new OS();
        private static final /* synthetic */ OS[] $VALUES;

        public static OS[] values() {
            return (OS[])$VALUES.clone();
        }

        public final String toString() {
            return this.name().toLowerCase(LOCALE);
        }

        static {
            $VALUES = new OS[]{DARWIN, FREEBSD, NETBSD, OPENBSD, LINUX, SOLARIS, WINDOWS, AIX, ZLINUX, UNKNOWN};
        }
    }
}

