/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ImportNotRecognizedException;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class ImportHandle {
    public final IDocument doc;
    public final String importFound;
    public final int startFoundLine;
    public int endFoundLine;
    private final List<ImportHandleInfo> importInfo;
    private final boolean allowBadInput;

    public ImportHandle(IDocument doc, String importFound, int startFoundLine, int endFoundLine, boolean allowBadInput) throws ImportNotRecognizedException {
        this.doc = doc;
        this.importFound = importFound;
        this.startFoundLine = startFoundLine;
        this.endFoundLine = endFoundLine;
        this.importInfo = new ArrayList<ImportHandleInfo>();
        this.allowBadInput = allowBadInput;
        int line = startFoundLine;
        boolean startedInMiddle = false;
        FastStringBuffer imp = new FastStringBuffer();
        ImportHandleInfo found = null;
        int i = 0;
        while (i < importFound.length()) {
            char c = importFound.charAt(i);
            if (c == '#') {
                i = ParsingUtils.create(importFound).eatComments(imp, i);
            } else if (c == ';') {
                String impStr = imp.toString();
                int endLine = line + StringUtils.countLineBreaks((String)impStr);
                found = new ImportHandleInfo(impStr, line, endLine, startedInMiddle, allowBadInput);
                this.importInfo.add(found);
                line = endLine;
                imp = imp.clear();
                startedInMiddle = true;
            } else {
                if (c == '\r' || c == '\n') {
                    startedInMiddle = false;
                }
                imp.append(c);
            }
            ++i;
        }
        String impStr = imp.toString();
        this.importInfo.add(new ImportHandleInfo(impStr, line, line + StringUtils.countLineBreaks((String)impStr), startedInMiddle, allowBadInput));
    }

    public ImportHandle(IDocument doc, String importFound, int startFoundLine, int endFoundLine) throws ImportNotRecognizedException {
        this(doc, importFound, startFoundLine, endFoundLine, false);
    }

    public boolean contains(ImportHandleInfo otherImportInfo) throws ImportNotRecognizedException {
        List<ImportHandleInfo> importHandleInfo = this.getImportInfo();
        for (ImportHandleInfo info : importHandleInfo) {
            if (info.fromStr != otherImportInfo.fromStr && (otherImportInfo.fromStr == null || info.fromStr == null || !otherImportInfo.fromStr.equals(info.fromStr)) || otherImportInfo.importedStr.size() != 1 || !info.importedStr.contains(otherImportInfo.importedStr.get(0))) continue;
            return true;
        }
        return false;
    }

    public List<ImportHandleInfo> getImportInfo() {
        return this.importInfo;
    }

    public static class ImportHandleInfo {
        private static final Pattern FromImportPattern = Pattern.compile("(from\\s+)(\\.|\\w)+((\\\\|\\s)+import(\\\\|\\s)+)");
        private static final Pattern BadFromPattern = Pattern.compile("from\\s+(\\.|\\w)+(\\\\|\\s)+import");
        private static final Pattern ImportPattern = Pattern.compile("(import\\s+)");
        private String fromStr;
        private List<String> importedStr;
        private List<String> importedStrComments;
        private int startLine;
        private int endLine;
        private boolean startedInMiddleOfLine;

        public ImportHandleInfo(String importFound) throws ImportNotRecognizedException {
            this(importFound, -1, -1, false, false);
        }

        /*
         * Enabled aggressive block sorting
         */
        public ImportHandleInfo(String importFound, int lineStart, int lineEnd, boolean startedInMiddleOfLine, boolean allowBadInput) throws ImportNotRecognizedException {
            this.startLine = lineStart;
            this.endLine = lineEnd;
            this.startedInMiddleOfLine = startedInMiddleOfLine;
            importFound = importFound.trim();
            if (importFound.length() == 0) {
                throw new ImportNotRecognizedException("Could not recognize empty string as import");
            }
            char firstChar = importFound.charAt(0);
            if (firstChar == 'f') {
                Matcher matcher = FromImportPattern.matcher(importFound);
                if (matcher.find()) {
                    this.fromStr = importFound.substring(matcher.end(1), matcher.end(2)).trim();
                    String importedStr = importFound.substring(matcher.end(3), importFound.length()).trim();
                    this.buildImportedList(importedStr);
                    return;
                }
                if (!allowBadInput) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
                if (!"from".equals(importFound)) {
                    if (!BadFromPattern.matcher(importFound).matches()) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
                }
                this.dummyImportList();
                return;
            }
            if (firstChar != 'i') throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
            Matcher matcher = ImportPattern.matcher(importFound);
            if (matcher.find()) {
                String importedStr = importFound.substring(matcher.end(1), importFound.length()).trim();
                this.buildImportedList(importedStr);
                return;
            }
            if (!allowBadInput) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
            if (!"import".equals(importFound)) throw new ImportNotRecognizedException("Could not recognize import: " + importFound);
            this.dummyImportList();
        }

        private void dummyImportList() {
            this.importedStrComments = Arrays.asList(new String[0]);
            this.importedStr = this.importedStrComments;
        }

        private void buildImportedList(String importedStr) {
            ArrayList<String> lst = new ArrayList<String>();
            ArrayList<String> importComments = new ArrayList<String>();
            FastStringBuffer alias = new FastStringBuffer();
            FastStringBuffer comments = new FastStringBuffer();
            int i = 0;
            while (i < importedStr.length()) {
                char c = importedStr.charAt(i);
                if (c == '#') {
                    comments = comments.clear();
                    i = ParsingUtils.create(importedStr).eatComments(comments, i);
                    this.addImportAlias(lst, importComments, alias, comments.toString());
                    alias = alias.clear();
                } else if (c == ',' || c == '\r' || c == '\n') {
                    this.addImportAlias(lst, importComments, alias, "");
                    alias = alias.clear();
                } else if (c != '(' && c != ')' && c != '\\') {
                    alias.append(c);
                }
                ++i;
            }
            if (alias.length() > 0) {
                this.addImportAlias(lst, importComments, alias, "");
            }
            this.importedStrComments = importComments;
            this.importedStr = lst;
        }

        private void addImportAlias(ArrayList<String> lst, ArrayList<String> importComments, FastStringBuffer alias, String importComment) {
            String aliasStr = alias.toString().trim();
            importComment = importComment.trim();
            if (aliasStr.length() > 0) {
                lst.add(aliasStr);
                importComments.add(importComment);
            } else if (importComment.length() > 0 && importComments.size() > 0) {
                importComments.set(importComments.size() - 1, importComment);
            }
        }

        public String getFromImportStr() {
            return this.fromStr;
        }

        public List<String> getImportedStr() {
            return this.importedStr;
        }

        public List<String> getCommentsForImports() {
            return this.importedStrComments;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public boolean getStartedInMiddleOfLine() {
            return this.startedInMiddleOfLine;
        }

        public List<Tuple<String, String>> getImportedStrAndComments() {
            ArrayList<Tuple<String, String>> lst = new ArrayList<Tuple<String, String>>();
            int i = 0;
            while (i < this.importedStr.size()) {
                lst.add((Tuple<String, String>)new Tuple((Object)this.importedStr.get(i), (Object)this.importedStrComments.get(i)));
                ++i;
            }
            return lst;
        }
    }
}

