/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.analysis.scopeanalysis.ScopeAnalysis;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import com.python.pydev.refactoring.wizards.rename.AbstractRenameWorkspaceRefactorProcess;
import com.python.pydev.refactoring.wizards.rename.IRefactorCustomEntry;
import com.python.pydev.refactoring.wizards.rename.MatchImportsVisitor;
import com.python.pydev.refactoring.wizards.rename.TextEditCreation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.modules.ASTEntryWithSourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.string.StringUtils;

public class PyRenameImportProcess
extends AbstractRenameWorkspaceRefactorProcess {
    public static final int TYPE_RENAME_MODULE = 1;
    public static final int TYPE_RENAME_UNRESOLVED_IMPORT = 2;
    protected int type = -1;
    protected SourceModule moduleToFind;

    public PyRenameImportProcess(Definition definition) {
        super(definition);
        this.type = definition.ast == null ? 1 : 2;
    }

    @Override
    public void findReferencesToRename(RefactoringRequest request, RefactoringStatus status) {
        if (request.isModuleRenameRefactoringRequest() && request.getSimpleResourceRename() && request.getIFileResource() != null) {
            return;
        }
        super.findReferencesToRename(request, status);
    }

    @Override
    protected void findReferencesToRenameOnLocalScope(RefactoringRequest request, RefactoringStatus status) {
        if (request.isModuleRenameRefactoringRequest()) {
            this.onModuleRenameRefactoringRequest(request);
        }
        List<ASTEntry> oc = this.getOccurrencesWithScopeAnalyzer(request, (SourceModule)request.getModule());
        SimpleNode root = request.getAST();
        if (oc.size() > 0) {
            oc.addAll(ScopeAnalysis.getCommentOccurrences((String)request.initialName, (SimpleNode)root));
            oc.addAll(ScopeAnalysis.getStringOccurrences((String)request.initialName, (SimpleNode)root));
        }
        this.addOccurrences(request, oc);
    }

    private void onModuleRenameRefactoringRequest(RefactoringRequest request) {
        this.moduleToFind = (SourceModule)request.getModule();
        ArrayList<ASTEntry> lst = new ArrayList<ASTEntry>();
        lst.add((ASTEntry)new ASTEntryWithSourceModule(this.moduleToFind));
        this.addOccurrences(lst, this.moduleToFind.getFile(), this.moduleToFind.getName());
    }

    @Override
    protected void doCheckInitialOnWorkspace(RefactoringStatus status, RefactoringRequest request) {
        boolean wasResolved = false;
        if (request.isModuleRenameRefactoringRequest()) {
            this.onModuleRenameRefactoringRequest(request);
            wasResolved = true;
        } else if (this.docOccurrences.size() != 0) {
            ASTEntry entry = (ASTEntry)this.docOccurrences.iterator().next();
            Found found = (Found)entry.getAdditionalInfo("FOUND_ADDITIONAL_INFO_IN_AST_ENTRY", null);
            if (found == null) {
                throw new RuntimeException("Expecting decorated entry.");
            }
            if (found.importInfo == null) {
                throw new RuntimeException("Expecting import info from the found entry.");
            }
            if (found.importInfo.wasResolved) {
                Definition d = found.importInfo.getModuleDefinitionFromImportInfo(request.nature, (ICompletionCache)new CompletionCache());
                if (d == null || d.module == null) {
                    status.addFatalError(StringUtils.format((String)"Unable to find the definition for the module.", (Object[])new Object[0]));
                    return;
                }
                if (!(d.module instanceof SourceModule)) {
                    status.addFatalError(StringUtils.format((String)"Only source modules may be renamed (the module %s was found as a %s module)", (Object[])new Object[]{d.module.getName(), d.module.getClass()}));
                    return;
                }
                this.moduleToFind = (SourceModule)d.module;
                wasResolved = true;
                if (!(found.importInfo.mod instanceof SourceModule)) {
                    status.addFatalError(StringUtils.format((String)"Error. The module %s may not be renamed\n(Because it was found as a compiled extension).", (Object[])new Object[]{found.importInfo.mod.getName()}));
                    return;
                }
                ISystemModulesManager systemModulesManager = request.nature.getAstManager().getModulesManager().getSystemModulesManager();
                IModule systemModule = systemModulesManager.getModule(found.importInfo.mod.getName(), request.nature, true);
                if (systemModule != null) {
                    status.addFatalError(StringUtils.format((String)"Error. The module '%s' may not be renamed\nOnly project modules may be renamed\n(and it was found as being a system module).", (Object[])new Object[]{found.importInfo.mod.getName()}));
                    return;
                }
                ArrayList<ASTEntry> lst = new ArrayList<ASTEntry>();
                lst.add((ASTEntry)new ASTEntryWithSourceModule(this.moduleToFind));
                this.addOccurrences(lst, this.moduleToFind.getFile(), this.moduleToFind.getName());
            }
        }
        if (wasResolved) {
            super.doCheckInitialOnWorkspace(status, request);
        }
    }

    @Override
    protected List<ASTEntry> findReferencesOnOtherModule(RefactoringStatus status, RefactoringRequest request, String initialName, SourceModule module) {
        List<ASTEntry> entryOccurrences = new ArrayList<ASTEntry>();
        try {
            this.checkProperRequest();
            MatchImportsVisitor visitor = new MatchImportsVisitor(request.nature, request.initialName, module, request.getMonitor());
            SimpleNode root = module.getAst();
            root.accept((VisitorIF)visitor);
            entryOccurrences = visitor.getEntryOccurrences();
            if (entryOccurrences.size() > 0) {
                Set<String> searchStringsAs = visitor.searchStringsAs;
                for (String string : searchStringsAs) {
                    entryOccurrences.addAll(this.convertToUseInitialName(string, ScopeAnalysis.getCommentOccurrences((String)string, (SimpleNode)root)));
                    entryOccurrences.addAll(this.convertToUseInitialName(string, ScopeAnalysis.getStringOccurrences((String)string, (SimpleNode)root)));
                }
            }
            entryOccurrences.addAll(this.convertToUseInitialName(request.initialName, ScopeAnalysis.getCommentOccurrences((String)request.initialName, (SimpleNode)root)));
            entryOccurrences.addAll(this.convertToUseInitialName(request.initialName, ScopeAnalysis.getStringOccurrences((String)request.initialName, (SimpleNode)root)));
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return entryOccurrences;
    }

    private Collection<ASTEntry> convertToUseInitialName(String string, List<ASTEntry> commentOccurrences) {
        ArrayList<ASTEntry> lst = new ArrayList<ASTEntry>(commentOccurrences.size());
        for (ASTEntry astEntry : commentOccurrences) {
            lst.add(new FixedInputStringASTEntry(string, null, astEntry.node, false));
        }
        return lst;
    }

    protected void checkProperRequest() throws AssertionError {
        if (!this.request.isModuleRenameRefactoringRequest()) {
            throw new AssertionError((Object)"To rename an import, a ModuleRenameRefactoringRequest is needed.");
        }
    }

    @Override
    protected boolean getRecheckWhereDefinitionWasFound() {
        return false;
    }

    public static final class FixedInputStringASTEntry
    extends ASTEntry
    implements IRefactorCustomEntry {
        private final String fixedInitialString;
        private final boolean forceFull;

        public FixedInputStringASTEntry(String s, ASTEntry parent, SimpleNode node, boolean forceFull) {
            super(parent, node);
            this.fixedInitialString = s;
            this.forceFull = forceFull;
        }

        @Override
        public List<TextEdit> createRenameEdit(IDocument doc, String initialName, String inputName, RefactoringStatus status, IPath file, IPythonNature nature) {
            initialName = this.fixedInitialString;
            if (!initialName.contains(".") && !this.forceFull) {
                inputName = FullRepIterable.getLastPart((String)inputName);
            }
            int offset = AbstractRenameRefactorProcess.getOffset(doc, this);
            TextEditCreation.checkExpectedInput(doc, this.node.beginLine, offset, initialName, status, file);
            ReplaceEdit replaceEdit = new ReplaceEdit(offset, initialName.length(), inputName);
            List<TextEdit> edits = Arrays.asList(replaceEdit);
            return edits;
        }
    }
}

