/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.changes.PyCompositeChange;
import com.python.pydev.refactoring.changes.PyRenameResourceChange;
import com.python.pydev.refactoring.wizards.IRefactorRenameProcess;
import com.python.pydev.refactoring.wizards.rename.PyReferenceSearcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.python.pydev.editor.refactoring.IPyRefactoringRequest;
import org.python.pydev.editor.refactoring.PyRefactoringRequest;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.search.replace.ChangedFilesChecker;

public class PyRenameEntryPoint
extends RenameProcessor {
    public static final Set<String> WORDS_THAT_CANNOT_BE_RENAMED;
    private final IPyRefactoringRequest fRequest;
    private List<Change> allChanges = new ArrayList<Change>();
    private final PyReferenceSearcher pyReferenceSearcher;
    public static final String IDENTIFIER = "org.python.pydev.pyRename";
    static RefactoringParticipant[] EMPTY_REFACTORING_PARTICIPANTS;

    static {
        String[] wordsThatCannotbeRenamed;
        WORDS_THAT_CANNOT_BE_RENAMED = new HashSet<String>();
        String[] stringArray = wordsThatCannotbeRenamed = new String[]{"and", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "not", "or", "pass", "print", "raise", "return", "try", "while", "with", "yield", "as"};
        int n = wordsThatCannotbeRenamed.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            WORDS_THAT_CANNOT_BE_RENAMED.add(string);
            ++n2;
        }
        EMPTY_REFACTORING_PARTICIPANTS = new RefactoringParticipant[0];
    }

    public PyRenameEntryPoint(RefactoringRequest request) {
        this((IPyRefactoringRequest)new PyRefactoringRequest(new RefactoringRequest[]{request}));
    }

    public PyRenameEntryPoint(IPyRefactoringRequest request) {
        this.fRequest = request;
        List requests = request.getRequests();
        this.pyReferenceSearcher = new PyReferenceSearcher(requests.toArray(new RefactoringRequest[requests.size()]));
    }

    public Object[] getElements() {
        return new Object[]{this.fRequest};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return "PyDev PyRenameProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    /*
     * Exception decompiling
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[DOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkResourcesToBeChanged(Set<IResource> resources, CheckConditionsContext context, RefactoringStatus refactoringStatus) throws CoreException {
        HashSet<IFile> affectedFiles = new HashSet<IFile>();
        for (IResource resource : resources) {
            if (!(resource instanceof IFile)) continue;
            IFile fileResource = (IFile)resource;
            affectedFiles.add(fileResource);
        }
        ChangedFilesChecker.checkFiles(affectedFiles, (Object)context, (RefactoringStatus)refactoringStatus);
    }

    /*
     * Exception decompiling
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        PyCompositeChange finalChange;
        if (this.fRequest.isModuleRenameRefactoringRequest() && this.fRequest.getSimpleResourceRename() && this.fRequest.getIFileResource() != null) {
            IFile targetFile = this.fRequest.getIFileResource();
            return new RenameResourceChange(targetFile.getFullPath(), this.fRequest.getInputName());
        }
        List requests = this.fRequest.getRequests();
        if (requests.size() == 1) {
            RefactoringRequest request = (RefactoringRequest)requests.get(0);
            boolean makeUndo = !request.isModuleRenameRefactoringRequest();
            finalChange = new PyCompositeChange("RenameChange: '" + request.initialName + "' to '" + request.inputName + "'", makeUndo);
        } else {
            boolean makeUndo = false;
            finalChange = new PyCompositeChange("Move: " + requests.size() + " resources to '" + this.fRequest.getInputName() + "'", makeUndo);
        }
        Collections.sort(this.allChanges, new Comparator<Change>(){

            @Override
            public int compare(Change o1, Change o2) {
                if (o1.getClass() != o2.getClass()) {
                    if (o1 instanceof PyRenameResourceChange) {
                        return 1;
                    }
                    if (o2 instanceof PyRenameResourceChange) {
                        return -1;
                    }
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        finalChange.addAll(this.allChanges.toArray(new Change[this.allChanges.size()]));
        return finalChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REFACTORING_PARTICIPANTS;
    }

    public HashSet<ASTEntry> getOccurrences() {
        HashSet<ASTEntry> allOccurrences = new HashSet<ASTEntry>();
        for (RefactoringRequest request : this.fRequest.getRequests()) {
            allOccurrences.addAll(this.pyReferenceSearcher.getLocalReferences(request));
        }
        return allOccurrences;
    }

    public Map<Tuple<String, File>, HashSet<ASTEntry>> getOccurrencesInOtherFiles() {
        HashMap<Tuple<String, File>, HashSet<ASTEntry>> allOccurrences = new HashMap<Tuple<String, File>, HashSet<ASTEntry>>();
        for (RefactoringRequest request : this.fRequest.getRequests()) {
            allOccurrences.putAll(this.pyReferenceSearcher.getWorkspaceReferences(request));
        }
        return allOccurrences;
    }

    public List<IRefactorRenameProcess> getAllProcesses() {
        ArrayList<IRefactorRenameProcess> allProcesses = new ArrayList<IRefactorRenameProcess>();
        for (RefactoringRequest request : this.fRequest.getRequests()) {
            List<IRefactorRenameProcess> processes = this.pyReferenceSearcher.getProcesses(request);
            if (processes == null) continue;
            allProcesses.addAll(processes);
        }
        return allProcesses;
    }
}

