/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.search;

import com.python.pydev.refactoring.IPyRefactoring2;
import com.python.pydev.refactoring.refactorer.search.AbstractPythonSearchQuery;
import com.python.pydev.refactoring.refactorer.search.copied.FileMatch;
import com.python.pydev.refactoring.refactorer.search.copied.LineElement;
import com.python.pydev.refactoring.search.FindOccurrencesSearchResult;
import com.python.pydev.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchResult;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class FindOccurrencesSearchQuery
extends AbstractPythonSearchQuery {
    private static final String DEFAULT_DESCRIPTION = "Workspace";
    private final IPyRefactoring2 pyRefactoring;
    private final RefactoringRequest req;
    private FindOccurrencesSearchResult findOccurrencesSearchResult;

    public FindOccurrencesSearchQuery(IPyRefactoring2 r, RefactoringRequest req) {
        super(req.initialName);
        this.pyRefactoring = r;
        this.req = req;
    }

    @Override
    public ISearchResult getSearchResult() {
        if (this.findOccurrencesSearchResult == null) {
            this.findOccurrencesSearchResult = new FindOccurrencesSearchResult(this);
        }
        return this.findOccurrencesSearchResult;
    }

    @Override
    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            Map occurrences;
            monitor.beginTask("Searching...", 100);
            this.req.pushMonitor(monitor);
            try {
                this.req.pushMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 80));
                occurrences = this.pyRefactoring.findAllOccurrences(this.req);
            }
            finally {
                this.req.popMonitor().done();
            }
            if (occurrences == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                int length = this.req.initialName.length();
                HashSet<Integer> foundOffsets = new HashSet<Integer>();
                try {
                    this.req.pushMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    Set entrySet = occurrences.entrySet();
                    this.req.getMonitor().beginTask("Resolving occurrences...", entrySet.size());
                    for (Map.Entry o : entrySet) {
                        foundOffsets.clear();
                        IFile workspaceFile = null;
                        try {
                            IProject project = null;
                            IPythonNature nature = this.req.nature;
                            if (nature != null) {
                                project = nature.getProject();
                            }
                            if ((workspaceFile = new PySourceLocatorBase().getWorkspaceFile((File)((Tuple)o.getKey()).o2, project)) == null) {
                                Log.logInfo((String)StringUtils.format((String)"Ignoring: %s. Unable to resolve to a file in the Eclipse workspace.", (Object[])new Object[]{((Tuple)o.getKey()).o2}));
                                continue;
                            }
                        }
                        catch (IllegalStateException e) {
                            String message = e.getMessage();
                            if (message != null && message.equals("Workspace is closed.")) continue;
                            throw e;
                        }
                        IDocument doc = FileUtilsFileBuffer.getDocFromResource((IResource)workspaceFile);
                        this.req.getMonitor().setTaskName("Resolving occurrences... " + workspaceFile);
                        for (ASTEntry entry : (HashSet)o.getValue()) {
                            int offset = AbstractRenameRefactorProcess.getOffset(doc, entry);
                            if (foundOffsets.contains(offset)) continue;
                            foundOffsets.add(offset);
                            PySelection ps = new PySelection(doc, offset);
                            int lineNumber = ps.getLineOfOffset();
                            String lineContents = ps.getLine(lineNumber);
                            int lineStartOffset = ps.getLineOffset(lineNumber);
                            LineElement element = new LineElement((IResource)workspaceFile, lineNumber, lineStartOffset, lineContents);
                            this.findOccurrencesSearchResult.addMatch(new FileMatch(workspaceFile, offset, length, element));
                        }
                    }
                }
                finally {
                    this.req.popMonitor().done();
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        finally {
            this.req.popMonitor().done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchString();
        if (searchString.length() > 0) {
            if (this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    return StringUtils.format((String)"%s - 1 match in %s", (Object[])new Object[]{searchString, this.getDescription()});
                }
                return StringUtils.format((String)"%s - %s matches in %s", (Object[])new Object[]{searchString, nMatches, this.getDescription()});
            }
            if (nMatches == 1) {
                return StringUtils.format((String)"%s - 1 match in %s", (Object[])new Object[]{searchString, this.getDescription()});
            }
            return StringUtils.format((String)"%s - %s matches in %s", (Object[])new Object[]{searchString, nMatches, this.getDescription()});
        }
        throw new RuntimeException("Unexpected condition when finding: " + searchString);
    }

    private String getDescription() {
        if (this.req.pyEdit == null) {
            return DEFAULT_DESCRIPTION;
        }
        IProject project = this.req.pyEdit.getProject();
        if (project == null) {
            return DEFAULT_DESCRIPTION;
        }
        return "'" + project.getName() + "' and related projects";
    }
}

