/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search.copied;

import com.python.pydev.refactoring.refactorer.search.copied.LineElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.Region;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.shared_ui.search.ICustomMatch;

public class FileMatch
extends Match
implements ICustomMatch {
    private LineElement fLineElement;
    private Region fOriginalLocation;
    private long fCreationTimeStamp;

    public FileMatch(IFile element) {
        super((Object)element, -1, -1);
        this.fLineElement = null;
        this.fOriginalLocation = null;
    }

    public FileMatch(IFile element, int offset, int length, LineElement lineEntry) {
        super((Object)element, offset, length);
        Assert.isLegal((lineEntry != null ? 1 : 0) != 0);
        this.fLineElement = lineEntry;
        this.fCreationTimeStamp = element.getModificationStamp();
    }

    public void setOffset(int offset) {
        if (this.fOriginalLocation == null) {
            this.fOriginalLocation = new Region(this.getOffset(), this.getLength());
        }
        super.setOffset(offset);
    }

    public void setLength(int length) {
        if (this.fOriginalLocation == null) {
            this.fOriginalLocation = new Region(this.getOffset(), this.getLength());
        }
        super.setLength(length);
    }

    public int getOriginalOffset() {
        if (this.fOriginalLocation != null) {
            return this.fOriginalLocation.getOffset();
        }
        return this.getOffset();
    }

    public int getOriginalLength() {
        if (this.fOriginalLocation != null) {
            return this.fOriginalLocation.getLength();
        }
        return this.getLength();
    }

    public LineElement getLineElement() {
        return this.fLineElement;
    }

    public IFile getFile() {
        return (IFile)this.getElement();
    }

    public boolean isFileSearch() {
        return this.fLineElement == null;
    }

    public long getCreationTimeStamp() {
        return this.fCreationTimeStamp;
    }
}

