/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.console.IHyperlink;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.ILinkContainer;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.structure.Location;

public class PythonConsoleLineTracker
implements IConsoleLineTracker {
    private ILinkContainer linkContainer;
    private boolean onlyCreateLinksForExistingFiles = true;
    static Pattern linePattern = Pattern.compile(".*(File) \\\"([^\\\"]*)\\\", line (\\d*).*");

    public void init(final IConsole console) {
        this.linkContainer = new ILinkContainer(){

            @Override
            public void addLink(IHyperlink link, int offset, int length) {
                console.addLink(link, offset, length);
            }

            @Override
            public String getContents(int offset, int length) throws BadLocationException {
                return console.getDocument().get(offset, length);
            }
        };
    }

    public void init(ILinkContainer linkContainer) {
        this.linkContainer = linkContainer;
    }

    public void lineAppended(IRegion line) {
        String text;
        int lineOffset = line.getOffset();
        int lineLength = line.getLength();
        try {
            text = this.linkContainer.getContents(lineOffset, lineLength);
        }
        catch (BadLocationException e) {
            PydevDebugPlugin.log(4, "unexpected error", e);
            return;
        }
        Matcher m = linePattern.matcher(text);
        String fileName = null;
        String lineNumber = null;
        int fileStart = -1;
        if (m.matches()) {
            fileName = m.group(2);
            lineNumber = m.group(3);
            fileStart = m.start(1);
        }
        if (fileName != null) {
            IFile file;
            Object link = null;
            int num = -1;
            try {
                num = lineNumber != null ? Integer.parseInt(lineNumber) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                num = 0;
            }
            if (SharedCorePlugin.inTestMode()) {
                file = null;
            } else {
                IProject project = null;
                IProcess process = DebugUITools.getCurrentProcess();
                if (process != null) {
                    ILaunchConfiguration lc = process.getLaunch().getLaunchConfiguration();
                    try {
                        project = lc.getMappedResources()[0].getProject();
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (CoreException e) {
                        Log.log((String)"Error accessing launched resources.", (Throwable)e);
                    }
                }
                file = new PySourceLocatorBase().getFileForLocation(Path.fromOSString((String)fileName), project);
            }
            if (file != null && file.exists()) {
                link = new FileLink(file, null, -1, -1, num);
            } else {
                File realFile = new File(fileName);
                if (!this.onlyCreateLinksForExistingFiles || realFile.exists()) {
                    ItemPointer p = new ItemPointer((Object)realFile, new Location(num - 1, 0), null);
                    link = new ConsoleLink(p);
                }
            }
            if (link != null) {
                this.linkContainer.addLink((IHyperlink)link, lineOffset + fileStart, lineLength - fileStart);
            }
        }
    }

    public void dispose() {
    }

    public void setOnlyCreateLinksForExistingFiles(boolean b) {
        this.onlyCreateLinksForExistingFiles = b;
    }

    public void splitInLinesAndAppendToLineTracker(String string) {
        int len = string.length();
        int last = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\r') {
                this.lineAppended((IRegion)new Region(last, i - last - 1));
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                last = i + 1;
            }
            if (c == '\n') {
                this.lineAppended((IRegion)new Region(last, i - last - 1));
                last = i + 1;
            }
            ++i;
        }
        this.lineAppended((IRegion)new Region(last, len - last));
    }

    public class ConsoleLink
    implements IHyperlink {
        ItemPointer pointer;

        public ConsoleLink(ItemPointer pointer) {
            this.pointer = pointer;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            PyOpenAction open = new PyOpenAction();
            open.run(this.pointer);
        }
    }
}

