/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.referrers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.XMLUtils;

public class ReferrersViewContentProvider
implements ITreeContentProvider {
    private final Map<Object, Object[]> childrenCache = new HashMap<Object, Object[]>();
    private final Map<Object, Object> parentCache = new HashMap<Object, Object>();

    public boolean hasChildren(Object element) {
        block5: {
            block6: {
                block4: {
                    if (!(element instanceof XMLUtils.XMLToReferrersInfo)) break block4;
                    return true;
                }
                if (!(element instanceof IVariable)) break block5;
                Object[] objects = this.childrenCache.get(element);
                if (objects == null || objects.length <= 0) break block6;
                return true;
            }
            try {
                IVariable iVariable = (IVariable)element;
                return iVariable.getValue().hasVariables();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return false;
    }

    public void dispose() {
        this.childrenCache.clear();
        this.parentCache.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.childrenCache.clear();
        this.parentCache.clear();
    }

    public Object[] getElements(Object inputElement) {
        XMLUtils.XMLToReferrersInfo[] arr = (XMLUtils.XMLToReferrersInfo[])inputElement;
        Object[] ret = new Object[arr.length];
        int len = arr.length;
        int i = 0;
        while (i < len) {
            ret[i] = this.getChildren(arr[i])[0];
            ++i;
        }
        return ret;
    }

    public Object[] getChildren(Object element) {
        Object[] objects;
        Object[] inCache = this.childrenCache.get(element);
        if (inCache != null) {
            return inCache;
        }
        if (element != null) {
            try {
                if (element instanceof XMLUtils.XMLToReferrersInfo) {
                    PyVariable[] vars;
                    XMLUtils.XMLToReferrersInfo xmlToReferrersInfo = (XMLUtils.XMLToReferrersInfo)element;
                    this.childrenCache.put(element, new Object[]{xmlToReferrersInfo.forVar});
                    this.parentCache.put(xmlToReferrersInfo.forVar, element);
                    this.childrenCache.put(xmlToReferrersInfo.forVar, xmlToReferrersInfo.vars);
                    PyVariable[] pyVariableArray = vars = xmlToReferrersInfo.vars;
                    int n = vars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PyVariable pyVariable = pyVariableArray[n2];
                        this.parentCache.put(pyVariable, xmlToReferrersInfo.forVar);
                        ++n2;
                    }
                } else if (element instanceof IVariable) {
                    IVariable[] childrenVariables;
                    IVariable parentVariable = (IVariable)element;
                    IVariable[] iVariableArray = childrenVariables = parentVariable.getValue().getVariables();
                    int n = childrenVariables.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IVariable childVariable = iVariableArray[n3];
                        this.parentCache.put(childVariable, parentVariable);
                        ++n3;
                    }
                    this.childrenCache.put(parentVariable, childrenVariables);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if ((objects = this.childrenCache.get(element)) == null) {
            Log.log((String)("Children of: " + element + " is null"));
            objects = new Object[]{};
        }
        return objects;
    }

    public Object getParent(Object element) {
        return this.parentCache.get(element);
    }
}

