/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.IPyUnitServer;
import org.python.pydev.debug.pyunit.IPyUnitServerListener;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitViewServerListener;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyUnitViewTestsHolder {
    public static int MAX_RUNS_TO_KEEP = 20;
    private static PyUnitTestRun lastPinned;
    private static PyUnitTestRun currentPinned;
    public static final CallbackWithListeners<PyUnitTestRun> onPinSelected;
    static final Object lockServerListeners;
    static final LinkedList<PyUnitViewServerListener> serverListeners;
    static Job saveDiskIndexJob;
    public static final Object saveTestsRunStateLock;

    static {
        onPinSelected = new CallbackWithListeners();
        lockServerListeners = new Object();
        serverListeners = new LinkedList();
        saveDiskIndexJob = new Job("Save PyUnit test runs"){
            {
                this.setPriority(40);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                PyUnitViewTestsHolder.saveTestsRunState(false);
                return Status.OK_STATUS;
            }
        };
        saveTestsRunStateLock = new Object();
    }

    public static PyUnitTestRun getLastPinned() {
        return lastPinned;
    }

    public static PyUnitTestRun getCurrentPinned() {
        return currentPinned;
    }

    public static void setCurrentPinned(PyUnitTestRun pin) {
        if (pin != null) {
            lastPinned = pin;
        }
        currentPinned = pin;
        onPinSelected.call((Object)pin);
    }

    public static void restoreTestsRunState() {
        try {
            String pinInfoContents;
            File workspaceMetadataFile = PyUnitViewTestsHolder.getPyUnitTestsDir();
            TreeMap<Integer, File> files = new TreeMap<Integer, File>();
            int i0 = "test_run_".length();
            File[] fileArray = workspaceMetadataFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String name = f.getName();
                if (name.endsWith(".xml") && name.startsWith("test_run_")) {
                    String val0 = name.substring(i0, name.length() - 4);
                    try {
                        int n3 = Integer.parseInt(val0);
                        files.put(n3, f);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++n2;
            }
            try {
                pinInfoContents = FileUtils.getFileContents((File)new File(workspaceMetadataFile, "test_run_pin_info.txt"));
            }
            catch (Exception exception) {
                pinInfoContents = null;
            }
            if (pinInfoContents == null) {
                pinInfoContents = "";
            }
            Tuple split = StringUtils.splitOnFirst((String)pinInfoContents, (char)'|');
            int currentPin = -1;
            int lastPin = -1;
            if (((String)split.o1).length() > 0) {
                try {
                    currentPin = Integer.parseInt((String)split.o1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (((String)split.o2).length() > 0) {
                try {
                    lastPin = Integer.parseInt((String)split.o2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int i = 0;
            while (files.size() > MAX_RUNS_TO_KEEP) {
                Iterator it = files.entrySet().iterator();
                Map.Entry<Integer, File> entry = it.next();
                if ((Integer)entry.getKey() == currentPin) {
                    try {
                        currentPinned = PyUnitTestRun.fromXML(FileUtils.getFileContents((File)((File)entry.getValue())));
                        PyUnitViewTestsHolder.setSavedDiskIndex(currentPinned, workspaceMetadataFile, i, entry);
                        ++i;
                        if (currentPin == lastPin) {
                            lastPinned = currentPinned;
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                } else if ((Integer)entry.getKey() == lastPin) {
                    try {
                        lastPinned = PyUnitTestRun.fromXML(FileUtils.getFileContents((File)((File)entry.getValue())));
                        PyUnitViewTestsHolder.setSavedDiskIndex(lastPinned, workspaceMetadataFile, i, entry);
                        ++i;
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                } else {
                    ((File)entry.getValue()).delete();
                }
                it.remove();
            }
            Set entrySet = files.entrySet();
            for (Map.Entry<Integer, File> entry : entrySet) {
                File file = (File)entry.getValue();
                try {
                    PyUnitTestRun testRunRestored = PyUnitTestRun.fromXML(FileUtils.getFileContents((File)file));
                    PyUnitViewTestsHolder.setSavedDiskIndex(testRunRestored, workspaceMetadataFile, i, entry);
                    ++i;
                    if (entry.getKey() == currentPin) {
                        currentPinned = testRunRestored;
                    }
                    if (entry.getKey() == lastPin) {
                        lastPinned = testRunRestored;
                    }
                    DummyPyUnitServer pyUnitServer = new DummyPyUnitServer(testRunRestored.getPyUnitLaunch());
                    PyUnitViewServerListener serverListener = new PyUnitViewServerListener((IPyUnitServer)pyUnitServer, testRunRestored);
                    PyUnitViewTestsHolder.addServerListener(serverListener);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private static void setSavedDiskIndex(PyUnitTestRun testRun, File workspaceMetadataFile, int i, Map.Entry<Integer, File> entry) {
        if (i != entry.getKey()) {
            entry.getValue().renameTo(new File(workspaceMetadataFile, "test_run_" + i + ".xml"));
        }
        testRun.savedDiskIndex = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addServerListener(PyUnitViewServerListener serverListener) {
        Object object = lockServerListeners;
        synchronized (object) {
            if (serverListeners.size() + 1 > MAX_RUNS_TO_KEEP) {
                serverListeners.removeFirst();
            }
            serverListeners.add(serverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTestsRunState(boolean forceWriteUnfinished) {
        try {
            ArrayList<PyUnitTestRun> lst;
            Object object = lockServerListeners;
            synchronized (object) {
                lst = new ArrayList<PyUnitTestRun>(serverListeners.size() + 2);
                for (PyUnitViewServerListener pyUnitViewServerListener : serverListeners) {
                    lst.add(pyUnitViewServerListener.getTestRun());
                }
            }
            object = saveTestsRunStateLock;
            synchronized (object) {
                File workspaceMetadataFile = PyUnitViewTestsHolder.getPyUnitTestsDir();
                int i = 0;
                PyUnitTestRun currPin = currentPinned;
                PyUnitTestRun lastPin = lastPinned;
                boolean foundCurr = false;
                boolean foundLast = false;
                for (PyUnitTestRun testRun : lst) {
                    if (testRun == currPin) {
                        foundCurr = true;
                    }
                    if (testRun == lastPin) {
                        foundLast = true;
                    }
                    if (testRun.savedDiskIndex == null || testRun.savedDiskIndex < i) continue;
                    i = testRun.savedDiskIndex + 1;
                }
                if (!foundCurr && currPin != null) {
                    lst.add(currPin);
                    if (currPin.savedDiskIndex != null && currPin.savedDiskIndex >= i) {
                        i = currPin.savedDiskIndex + 1;
                    }
                }
                if (!foundLast && lastPin != null) {
                    lst.add(lastPin);
                    if (lastPin.savedDiskIndex != null && lastPin.savedDiskIndex >= i) {
                        i = lastPin.savedDiskIndex + 1;
                    }
                }
                for (PyUnitTestRun testRun : lst) {
                    if (testRun.savedDiskIndex != null || !forceWriteUnfinished && !testRun.getFinished()) continue;
                    String xml = testRun.toXML();
                    File f = new File(workspaceMetadataFile, "test_run_" + i + ".xml");
                    FileUtils.writeBytesToFile((byte[])xml.getBytes(StandardCharsets.UTF_8), (File)f);
                    testRun.savedDiskIndex = i;
                    ++i;
                }
                FastStringBuffer buf = new FastStringBuffer();
                if (currPin != null) {
                    buf.append(currPin.savedDiskIndex.intValue());
                }
                buf.append('|');
                if (lastPin != null) {
                    buf.append(lastPin.savedDiskIndex.intValue());
                }
                FileUtils.writeBytesToFile((byte[])buf.getBytes(), (File)new File(workspaceMetadataFile, "test_run_pin_info.txt"));
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private static File getPyUnitTestsDir() {
        File workspaceMetadataFile = PydevPlugin.getWorkspaceMetadataFile((String)"pyunit_tests");
        if (!workspaceMetadataFile.exists()) {
            workspaceMetadataFile.mkdirs();
        }
        return workspaceMetadataFile;
    }

    static class DummyPyUnitServer
    implements IPyUnitServer {
        private IPyUnitLaunch launch;

        public DummyPyUnitServer(IPyUnitLaunch launch) {
            this.launch = launch;
        }

        @Override
        public void registerOnNotifyTest(IPyUnitServerListener pyUnitViewServerListener) {
        }

        @Override
        public IPyUnitLaunch getPyUnitLaunch() {
            return this.launch;
        }
    }
}

