/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.python.pydev.debug.core.ConfigureExceptionsFileUtils;
import org.python.pydev.debug.model.IPropertyTraceListener;
import org.python.pydev.shared_core.callbacks.ListenerList;

public class PyPropertyTraceManager {
    public static final String PROPERTY_TRACE_STATE = "property_trace_state.prefs";
    private static PyPropertyTraceManager pyPropertyTraceManager;
    private ListenerList<IPropertyTraceListener> listeners = new ListenerList(IPropertyTraceListener.class);

    private PyPropertyTraceManager() {
    }

    public static synchronized PyPropertyTraceManager getInstance() {
        if (pyPropertyTraceManager == null) {
            pyPropertyTraceManager = new PyPropertyTraceManager();
        }
        return pyPropertyTraceManager;
    }

    public String getPyPropertyTraceState() {
        return ConfigureExceptionsFileUtils.readFromMetadataFile(PROPERTY_TRACE_STATE);
    }

    public void setPyPropertyTraceState(boolean replaceProperty, boolean disableGetterTrace, boolean disableSetterTrace, boolean disableDelterTrace) {
        String propertyTrace = String.valueOf(Boolean.toString(replaceProperty)) + ConfigureExceptionsFileUtils.DELIMITER + Boolean.toString(disableGetterTrace) + ConfigureExceptionsFileUtils.DELIMITER + Boolean.toString(disableSetterTrace) + ConfigureExceptionsFileUtils.DELIMITER + Boolean.toString(disableDelterTrace);
        ConfigureExceptionsFileUtils.writeToFile(PROPERTY_TRACE_STATE, propertyTrace, false);
        IPropertyTraceListener[] iPropertyTraceListenerArray = (IPropertyTraceListener[])this.listeners.getListeners();
        int n = iPropertyTraceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyTraceListener listener = iPropertyTraceListenerArray[n2];
            listener.onSetPropertyTraceConfiguration();
            ++n2;
        }
    }

    public void addListener(IPropertyTraceListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IPropertyTraceListener listener) {
        this.listeners.remove((Object)listener);
    }
}

