/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyExceptionBreakPointManager;
import org.python.pydev.debug.model.PyPropertyTraceManager;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;

public class PyDebugTarget
extends AbstractDebugTarget {
    public volatile IProcess process;
    public final IProject project;
    public volatile boolean finishedInit = false;
    public final boolean isAuxiliaryDebugTarget;

    public PyDebugTarget(ILaunch launch, IProcess process, IPath[] file, AbstractRemoteDebugger debugger, IProject project) {
        this(launch, process, file, debugger, project, false);
    }

    public PyDebugTarget(ILaunch launch, IProcess process, IPath[] file, AbstractRemoteDebugger debugger, IProject project, boolean isAuxiliaryDebugTarget) {
        this.launch = launch;
        this.process = process;
        this.file = file;
        this.debugger = debugger;
        this.threads = new PyThread[0];
        this.project = project;
        this.isAuxiliaryDebugTarget = isAuxiliaryDebugTarget;
        launch.addDebugTarget((IDebugTarget)this);
        debugger.addTarget(this);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        PyExceptionBreakPointManager.getInstance().addListener(this);
        PyPropertyTraceManager.getInstance().addListener(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public void launchRemoved(ILaunch launch) {
        if (launch == this.launch) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            breakpointManager.removeBreakpointListener((IBreakpointListener)this);
            PyExceptionBreakPointManager.getInstance().removeListener(this);
            PyPropertyTraceManager.getInstance().removeListener(this);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    public IProcess getProcess() {
        return this.process;
    }

    @Override
    public boolean canTerminate() {
        if (!this.finishedInit) {
            return false;
        }
        return !this.isTerminated();
    }

    @Override
    public boolean isTerminated() {
        if (!this.finishedInit) {
            return false;
        }
        if (this.process == null) {
            return true;
        }
        return this.process.isTerminated();
    }

    @Override
    public void terminate() {
        if (this.process != null) {
            if (!this.isAuxiliaryDebugTarget) {
                try {
                    this.process.terminate();
                }
                catch (DebugException e) {
                    Log.log((Throwable)e);
                }
            }
            this.process = null;
        }
        super.terminate();
    }
}

