/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleViewer;

public class PromptOverlayReplaceGlobalActionHandlers {
    private final HashMap<String, IAction> newActions = new HashMap();
    private final FocusListener focusListener;
    private final ScriptConsoleViewer viewer;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PromptOverlayReplaceGlobalActionHandlers.this.updateSelectionDependentActions();
        }
    };
    protected ArrayList<String> selectionDependentActionIds = new ArrayList();

    public PromptOverlayReplaceGlobalActionHandlers(final IOConsolePage consolePage, final ScriptConsoleViewer viewer) {
        this.viewer = viewer;
        final HashMap old = new HashMap();
        TextViewerAction action = new TextViewerAction((ITextViewer)viewer, 7);
        action.configureAction("Select &All", "Select All", "Select All");
        action.setActionDefinitionId(ActionFactory.SELECT_ALL.getCommandId());
        this.newActions.put(ActionFactory.SELECT_ALL.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)viewer, 4);
        action.configureAction("&Copy", "Copy", "Copy");
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        action.setActionDefinitionId(ActionFactory.COPY.getCommandId());
        this.newActions.put(ActionFactory.COPY.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)viewer, 5);
        action.configureAction("&Paste", "Paste", "Paste");
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        action.setActionDefinitionId(ActionFactory.PASTE.getCommandId());
        this.newActions.put(ActionFactory.PASTE.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)viewer, 3);
        action.configureAction("C&ut", "Cut", "Cut");
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        action.setActionDefinitionId(ActionFactory.CUT.getCommandId());
        this.newActions.put(ActionFactory.CUT.getId(), (IAction)action);
        ListResourceBundle bundle = new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                return new Object[0][0];
            }
        };
        FindReplaceAction findAction = new FindReplaceAction((ResourceBundle)bundle, "Editor.FindReplace.", viewer.getControl().getShell(), viewer.getFindReplaceTarget());
        findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.newActions.put(ActionFactory.FIND.getId(), (IAction)findAction);
        this.selectionDependentActionIds.add(ActionFactory.CUT.getId());
        this.selectionDependentActionIds.add(ActionFactory.COPY.getId());
        this.selectionDependentActionIds.add(ActionFactory.PASTE.getId());
        this.selectionDependentActionIds.add(ActionFactory.FIND.getId());
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (old.size() == 0) {
                    return;
                }
                IPageSite site = consolePage.getSite();
                IActionBars actionBars = site.getActionBars();
                site.setSelectionProvider((ISelectionProvider)consolePage.getViewer());
                viewer.getSelectionProvider().removeSelectionChangedListener(PromptOverlayReplaceGlobalActionHandlers.this.selectionChangedListener);
                for (Map.Entry oldEntry : old.entrySet()) {
                    String actionId = (String)oldEntry.getKey();
                    actionBars.setGlobalActionHandler(actionId, (IAction)oldEntry.getValue());
                }
                old.clear();
                actionBars.updateActionBars();
            }

            public void focusGained(FocusEvent e) {
                if (old.size() > 0) {
                    return;
                }
                IPageSite site = consolePage.getSite();
                site.setSelectionProvider((ISelectionProvider)viewer);
                viewer.getSelectionProvider().addSelectionChangedListener(PromptOverlayReplaceGlobalActionHandlers.this.selectionChangedListener);
                IActionBars actionBars = site.getActionBars();
                for (Map.Entry entry : PromptOverlayReplaceGlobalActionHandlers.this.newActions.entrySet()) {
                    String actionId = (String)entry.getKey();
                    IAction globalActionHandler = actionBars.getGlobalActionHandler(actionId);
                    old.put(actionId, globalActionHandler);
                    actionBars.setGlobalActionHandler(actionId, (IAction)entry.getValue());
                }
                actionBars.updateActionBars();
            }
        };
        viewer.getTextWidget().addFocusListener(this.focusListener);
    }

    protected void updateSelectionDependentActions() {
        for (String string : this.selectionDependentActionIds) {
            IAction action = this.newActions.get(string);
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    public void dispose() {
        StyledText textWidget = this.viewer.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            textWidget.removeFocusListener(this.focusListener);
        }
    }
}

