/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;

enum InitializerRequirement {
    NONE_REQUIRED,
    VALUE_REQUIRED,
    OTHER_REQUIRED;


    public static InitializerRequirement calcInitializerRequirement(PsiClass psiClass) {
        PsiMethod[] methods;
        if (psiClass == null || !psiClass.isAnnotationType()) {
            return NONE_REQUIRED;
        }
        InitializerRequirement r = NONE_REQUIRED;
        for (PsiMethod method : methods = psiClass.getMethods()) {
            PsiAnnotationMethod annotationMethod;
            if (!PsiUtil.isAnnotationMethod((PsiElement)method) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null) continue;
            if ("value".equals(annotationMethod.getName())) {
                return VALUE_REQUIRED;
            }
            r = OTHER_REQUIRED;
        }
        return r;
    }
}

