/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java.validation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;

public class UnknownLanguageID
extends LocalInspectionTool {
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public String getGroupDisplayName() {
        return "Language Injection";
    }

    public String getDisplayName() {
        return "Unknown Language ID";
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){
            final String annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getLanguageAnnotationClass();
            }

            public void visitNameValuePair(PsiNameValuePair valuePair) {
                PsiExpression expression;
                Object id;
                PsiAnnotationMemberValue value;
                String name;
                String qualifiedName;
                PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)valuePair, PsiAnnotation.class);
                if (annotation != null && this.annotationName.equals(qualifiedName = annotation.getQualifiedName()) && ((name = valuePair.getName()) == null || "value".equals(name)) && (value = valuePair.getValue()) instanceof PsiExpression && (id = JavaPsiFacade.getInstance((Project)(expression = (PsiExpression)value).getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expression)) instanceof String && InjectedLanguage.findLanguageById((String)id) == null && ReferenceInjector.findById((String)((String)id)) == null) {
                    holder.registerProblem((PsiElement)expression, "Unknown language '" + id + "'", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                }
            }
        };
    }

    public String getShortName() {
        return "UnknownLanguage";
    }
}

