/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class InjectedLanguage {
    private static Map<String, Language> ourLanguageCache;
    private static int ourLanguageCount;
    private final String myID;
    private final String myPrefix;
    private final String mySuffix;
    private final boolean myDynamic;

    private InjectedLanguage(String id, String prefix, String suffix, boolean dynamic) {
        this.myID = id;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
        this.myDynamic = dynamic;
    }

    public String getID() {
        return this.myID;
    }

    public Language getLanguage() {
        return InjectedLanguage.findLanguageById(this.myID);
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public String getSuffix() {
        return this.mySuffix;
    }

    public boolean isDynamic() {
        return this.myDynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language findLanguageById(String langID) {
        if (langID == null || langID.length() == 0) {
            return null;
        }
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ourLanguageCache.get(langID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAvailableLanguageIDs() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            Set<String> keys = ourLanguageCache.keySet();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ArrayUtil.toStringArray(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language[] getAvailableLanguages() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            Collection<Language> keys = ourLanguageCache.values();
            // ** MonitorExit[var0] (shouldn't be in output)
            return keys.toArray(new Language[keys.size()]);
        }
    }

    private static void initLanguageCache() {
        ArrayList registeredLanguages;
        ourLanguageCache = new HashMap<String, Language>();
        do {
            registeredLanguages = new ArrayList(Language.getRegisteredLanguages());
            for (Language language : registeredLanguages) {
                if (!LanguageUtil.isInjectableLanguage((Language)language)) continue;
                ourLanguageCache.put(language.getID(), language);
            }
        } while (Language.getRegisteredLanguages().size() != registeredLanguages.size());
        ourLanguageCount = registeredLanguages.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectedLanguage that = (InjectedLanguage)o;
        return !(this.myID == null ? that.myID != null : !this.myID.equals(that.myID));
    }

    public int hashCode() {
        return this.myID != null ? this.myID.hashCode() : 0;
    }

    public static InjectedLanguage create(String id) {
        return InjectedLanguage.create(id, "", "", false);
    }

    public static InjectedLanguage create(String id, String prefix, String suffix, boolean isDynamic) {
        return id == null ? null : new InjectedLanguage(id, prefix == null ? "" : prefix, suffix == null ? "" : suffix, isDynamic);
    }
}

