/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;

public final class DefaultLanguageInjector
implements MultiHostInjector {
    private final Configuration myInjectionConfiguration;
    private final LanguageInjectionSupport[] mySupports;

    public DefaultLanguageInjector(Configuration configuration) {
        this.myInjectionConfiguration = configuration;
        this.mySupports = (LanguageInjectionSupport[])ArrayUtil.toObjectArray(InjectorUtils.getActiveInjectionSupports(), LanguageInjectionSupport.class);
    }

    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Collections.singletonList(PsiLanguageInjectionHost.class);
    }

    public void getLanguagesToInject(MultiHostRegistrar registrar, PsiElement context) {
        if (!(context instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)context).isValidHost()) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        for (LanguageInjectionSupport support : this.mySupports) {
            if (!support.isApplicableTo(host) || !support.useDefaultInjector(host)) continue;
            for (BaseInjection injection : this.myInjectionConfiguration.getInjections(support.getId())) {
                if (!injection.acceptsPsiElement((PsiElement)host) || !InjectorUtils.registerInjectionSimple(host, injection, support, registrar)) continue;
                return;
            }
        }
    }
}

