/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;

public class VersionMatcher {
    private static final String RANGE_TOKEN = " <=> ";
    private final GradleVersion myGradleVersion;

    public VersionMatcher(GradleVersion version) {
        this.myGradleVersion = version;
    }

    public boolean isVersionMatch(TargetVersions targetVersions) {
        if (targetVersions == null || targetVersions.value() == null || targetVersions.value().isEmpty()) {
            return true;
        }
        GradleVersion current = VersionMatcher.adjust(this.myGradleVersion, targetVersions.checkBaseVersions());
        if (targetVersions.value().endsWith("+")) {
            String minVersion = targetVersions.value().substring(0, targetVersions.value().length() - 1);
            return VersionMatcher.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0;
        }
        int rangeIndex = targetVersions.value().indexOf(RANGE_TOKEN);
        if (rangeIndex != -1) {
            String minVersion = targetVersions.value().substring(0, rangeIndex);
            String maxVersion = targetVersions.value().substring(rangeIndex + RANGE_TOKEN.length());
            return VersionMatcher.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0 && VersionMatcher.compare(current, maxVersion, targetVersions.checkBaseVersions()) <= 0;
        }
        return VersionMatcher.compare(current, targetVersions.value(), targetVersions.checkBaseVersions()) == 0;
    }

    private static int compare(GradleVersion gradleVersion, String otherGradleVersion, boolean checkBaseVersions) {
        return gradleVersion.compareTo(VersionMatcher.adjust(GradleVersion.version((String)otherGradleVersion), checkBaseVersions));
    }

    private static GradleVersion adjust(GradleVersion version, boolean checkBaseVersions) {
        return checkBaseVersions ? version.getBaseVersion() : version;
    }
}

