/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.PackageSetChooserCombo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.ui.CopyrightProfilesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ProjectSettingsPanel {
    private final Project myProject;
    private final CopyrightProfilesPanel myProfilesModel;
    private final CopyrightManager myManager;
    private final TableView<ScopeSetting> myScopeMappingTable;
    private final ListTableModel<ScopeSetting> myScopeMappingModel;
    private final JComboBox myProfilesComboBox = new JComboBox();
    private final HyperlinkLabel myScopesLink = new HyperlinkLabel();

    public ProjectSettingsPanel(Project project, CopyrightProfilesPanel profilesModel) {
        this.myProject = project;
        this.myProfilesModel = profilesModel;
        this.myProfilesModel.addItemsChangeListener(new Runnable(){

            @Override
            public void run() {
                Object selectedItem = ProjectSettingsPanel.this.myProfilesComboBox.getSelectedItem();
                ProjectSettingsPanel.this.reloadCopyrightProfiles();
                ProjectSettingsPanel.this.myProfilesComboBox.setSelectedItem(selectedItem);
                ArrayList<ScopeSetting> toRemove = new ArrayList<ScopeSetting>();
                for (ScopeSetting setting : ProjectSettingsPanel.this.myScopeMappingModel.getItems()) {
                    if (setting.getProfile() != null) continue;
                    toRemove.add(setting);
                }
                for (ScopeSetting setting : toRemove) {
                    ProjectSettingsPanel.this.myScopeMappingModel.removeRow(ProjectSettingsPanel.this.myScopeMappingModel.indexOf((Object)setting));
                }
            }
        });
        this.myManager = CopyrightManager.getInstance(project);
        ColumnInfo[] columns = new ColumnInfo[]{new ScopeColumn(), new SettingColumn()};
        this.myScopeMappingModel = new ListTableModel(columns, new ArrayList(), 0);
        this.myScopeMappingTable = new TableView(this.myScopeMappingModel);
        this.reloadCopyrightProfiles();
        this.myProfilesComboBox.setRenderer(new ListCellRendererWrapper<CopyrightProfile>(){

            public void customize(JList list, CopyrightProfile value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.setText("No copyright");
                } else {
                    this.setText(value.getName());
                }
            }
        });
        this.myScopesLink.setVisible(!this.myProject.isDefault());
        this.myScopesLink.setHyperlinkText("Select Scopes to add new scopes or modify existing ones");
        this.myScopesLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Settings settings;
                DataContext context;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult()) != null && (settings = (Settings)Settings.KEY.getData(context)) != null) {
                    settings.select(settings.find("project.scopes"));
                }
            }
        });
    }

    public void reloadCopyrightProfiles() {
        DefaultComboBoxModel boxModel = (DefaultComboBoxModel)this.myProfilesComboBox.getModel();
        boxModel.removeAllElements();
        boxModel.addElement(null);
        for (CopyrightProfile profile : this.myProfilesModel.getAllProfiles().values()) {
            boxModel.addElement(profile);
        }
    }

    public JComponent getMainComponent() {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        LabeledComponent component = new LabeledComponent();
        component.setText("Default &project copyright:");
        component.setLabelLocation("West");
        component.setComponent((JComponent)this.myProfilesComboBox);
        panel.add((Component)component, "North");
        ElementProducer<ScopeSetting> producer = new ElementProducer<ScopeSetting>(){

            public ScopeSetting createElement() {
                return new ScopeSetting(DefaultScopesProvider.getAllScope(), ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().values().iterator().next());
            }

            public boolean canCreateElement() {
                return !ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().isEmpty();
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myScopeMappingTable, (ElementProducer)producer);
        panel.add((Component)decorator.createPanel(), "Center");
        panel.add((Component)this.myScopesLink, "South");
        return panel;
    }

    public boolean isModified() {
        Map<String, String> map;
        Object selected;
        CopyrightProfile defaultCopyright = this.myManager.getDefaultCopyright();
        if (defaultCopyright != (selected = this.myProfilesComboBox.getSelectedItem())) {
            if (selected == null) {
                return true;
            }
            if (defaultCopyright == null) {
                return true;
            }
            if (!defaultCopyright.equals(selected)) {
                return true;
            }
        }
        if ((map = this.myManager.getCopyrightsMapping()).size() != this.myScopeMappingModel.getItems().size()) {
            return true;
        }
        Iterator<String> iterator = map.keySet().iterator();
        for (ScopeSetting setting : this.myScopeMappingModel.getItems()) {
            NamedScope scope = setting.getScope();
            if (!iterator.hasNext()) {
                return true;
            }
            String scopeName = iterator.next();
            if (scope == null || !Comparing.strEqual((String)scopeName, (String)scope.getName())) {
                return true;
            }
            String profileName = map.get(scope.getName());
            if (profileName == null) {
                return true;
            }
            if (profileName.equals(setting.getProfileName())) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        ArrayList<CopyrightProfile> profiles = new ArrayList<CopyrightProfile>(this.myManager.getCopyrights());
        this.myManager.clearCopyrights();
        for (CopyrightProfile profile : profiles) {
            this.myManager.addCopyright(profile);
        }
        List settingList = this.myScopeMappingModel.getItems();
        for (ScopeSetting scopeSetting : settingList) {
            this.myManager.mapCopyright(scopeSetting.getScope().getName(), scopeSetting.getProfileName());
        }
        this.myManager.setDefaultCopyright((CopyrightProfile)((Object)this.myProfilesComboBox.getSelectedItem()));
    }

    public void reset() {
        this.myProfilesComboBox.setSelectedItem((Object)this.myManager.getDefaultCopyright());
        ArrayList<ScopeSetting> mappings = new ArrayList<ScopeSetting>();
        Map<String, String> copyrights = this.myManager.getCopyrightsMapping();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)this.myProject);
        HashSet<String> scopes2Unmap = new HashSet<String>();
        for (String scopeName : copyrights.keySet()) {
            NamedScope scope = manager.getScope(scopeName);
            if (scope != null) {
                mappings.add(new ScopeSetting(scope, copyrights.get(scopeName)));
                continue;
            }
            scopes2Unmap.add(scopeName);
        }
        for (String scopeName : scopes2Unmap) {
            this.myManager.unmapCopyright(scopeName);
        }
        this.myScopeMappingModel.setItems(mappings);
    }

    private static abstract class MyColumnInfo<T>
    extends ColumnInfo<ScopeSetting, T> {
        protected MyColumnInfo(String name) {
            super(name);
        }

        public boolean isCellEditable(ScopeSetting item) {
            return true;
        }
    }

    private class ScopeColumn
    extends MyColumnInfo<NamedScope> {
        private ScopeColumn() {
            super("Scope");
        }

        public TableCellRenderer getRenderer(ScopeSetting mapping) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value == null) {
                        this.setText("");
                    } else {
                        NamedScope scope;
                        String scopeName = ((NamedScope)value).getName();
                        if (!isSelected && (scope = NamedScopesHolder.getScope((Project)ProjectSettingsPanel.this.myProject, (String)scopeName)) == null) {
                            this.setForeground((Color)JBColor.RED);
                        }
                        this.setText(scopeName);
                    }
                    return this;
                }
            };
        }

        public TableCellEditor getEditor(ScopeSetting mapping) {
            return new AbstractTableCellEditor(){
                private PackageSetChooserCombo myScopeChooser;

                public Object getCellEditorValue() {
                    return this.myScopeChooser.getSelectedScope();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myScopeChooser = new PackageSetChooserCombo(ProjectSettingsPanel.this.myProject, value == null ? null : ((NamedScope)value).getName(), false, false){

                        protected NamedScope[] createModel() {
                            NamedScope[] model = super.createModel();
                            ArrayList<NamedScope> filteredScopes = new ArrayList<NamedScope>(Arrays.asList(model));
                            CustomScopesProviderEx.filterNoSettingsScopes((Project)ProjectSettingsPanel.this.myProject, filteredScopes);
                            return filteredScopes.toArray(new NamedScope[filteredScopes.size()]);
                        }
                    };
                    ((JBComboBoxTableCellEditorComponent)this.myScopeChooser.getChildComponent()).setCell(table, row, column);
                    return this.myScopeChooser;
                }
            };
        }

        public NamedScope valueOf(ScopeSetting mapping) {
            return mapping.getScope();
        }

        public void setValue(ScopeSetting mapping, NamedScope set) {
            mapping.setScope(set);
        }
    }

    private class SettingColumn
    extends MyColumnInfo<CopyrightProfile> {
        private SettingColumn() {
            super("Copyright");
        }

        public TableCellRenderer getRenderer(final ScopeSetting scopeSetting) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!isSelected) {
                        CopyrightProfile profile = ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().get(scopeSetting.getProfileName());
                        this.setForeground((Color)(profile == null ? JBColor.RED : UIUtil.getTableForeground()));
                    }
                    this.setText(scopeSetting.getProfileName());
                    return rendererComponent;
                }
            };
        }

        public TableCellEditor getEditor(final ScopeSetting scopeSetting) {
            return new AbstractTableCellEditor(){
                private final JBComboBoxTableCellEditorComponent myProfilesChooser = new JBComboBoxTableCellEditorComponent();

                public Object getCellEditorValue() {
                    return this.myProfilesChooser.getEditorValue();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    ArrayList<CopyrightProfile> copyrights = new ArrayList<CopyrightProfile>(ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().values());
                    Collections.sort(copyrights, new Comparator<CopyrightProfile>(){

                        @Override
                        public int compare(CopyrightProfile o1, CopyrightProfile o2) {
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                    });
                    this.myProfilesChooser.setCell(table, row, column);
                    this.myProfilesChooser.setOptions(copyrights.toArray());
                    this.myProfilesChooser.setDefaultValue((Object)scopeSetting.getProfile());
                    this.myProfilesChooser.setToString((Function)new Function<Object, String>(){

                        public String fun(Object o) {
                            return ((CopyrightProfile)((Object)o)).getName();
                        }
                    });
                    return this.myProfilesChooser;
                }
            };
        }

        public CopyrightProfile valueOf(ScopeSetting object) {
            return object.getProfile();
        }

        public void setValue(ScopeSetting scopeSetting, CopyrightProfile copyrightProfile) {
            if (copyrightProfile != null) {
                scopeSetting.setProfile(copyrightProfile);
            }
        }
    }

    private class ScopeSetting {
        private NamedScope myScope;
        private CopyrightProfile myProfile;
        private String myProfileName;

        private ScopeSetting(NamedScope scope, CopyrightProfile profile) {
            this.myScope = scope;
            this.myProfile = profile;
            if (this.myProfile != null) {
                this.myProfileName = this.myProfile.getName();
            }
        }

        public ScopeSetting(NamedScope scope, String profile) {
            this.myScope = scope;
            this.myProfileName = profile;
        }

        public CopyrightProfile getProfile() {
            if (this.myProfileName != null) {
                this.myProfile = ProjectSettingsPanel.this.myProfilesModel.getAllProfiles().get(this.getProfileName());
            }
            return this.myProfile;
        }

        public void setProfile(CopyrightProfile profile) {
            this.myProfile = profile;
            this.myProfileName = profile.getName();
        }

        public NamedScope getScope() {
            return this.myScope;
        }

        public void setScope(NamedScope scope) {
            this.myScope = scope;
        }

        public String getProfileName() {
            return this.myProfile != null ? this.myProfile.getName() : this.myProfileName;
        }
    }
}

