/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.updater.configure.BuildToolsSummaryTreeNode;
import com.android.tools.idea.updater.configure.DownloadStatusColumnInfo;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.ParentTreeNode;
import com.android.tools.idea.updater.configure.PlatformDetailsTreeNode;
import com.android.tools.idea.updater.configure.RootNode;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.StatusColumnInfo;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.android.tools.idea.updater.configure.VersionColumnInfo;
import com.google.common.collect.Sets;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;

public class ToolComponentsPanel {
    private TreeTableView myToolsSummaryTable;
    private JCheckBox myToolsDetailsCheckbox;
    private JPanel myToolsPanel;
    private TreeTableView myToolsDetailTable;
    private JPanel myToolsLoadingPanel;
    private AsyncProcessIcon myToolsLoadingIcon;
    private JPanel myRootPanel;
    private Set<UpdatablePkgInfo> myToolsPackages;
    private Set<UpdatablePkgInfo> myBuildToolsPackages;
    private UpdaterTreeNode myToolsDetailsRootNode;
    private UpdaterTreeNode myToolsSummaryRootNode;
    Set<NodeStateHolder> myStates;
    private boolean myModified;
    private boolean myIncludePreview;
    private final ChangeListener myModificationListener;

    public ToolComponentsPanel() {
        this.$$$setupUI$$$();
        this.myToolsPackages = Sets.newTreeSet((Comparator)new Comparator<UpdatablePkgInfo>(){

            @Override
            public int compare(UpdatablePkgInfo o1, UpdatablePkgInfo o2) {
                return o1.getPkgDesc(ToolComponentsPanel.this.myIncludePreview).getListDescription().compareTo(o2.getPkgDesc(ToolComponentsPanel.this.myIncludePreview).getListDescription());
            }
        });
        this.myBuildToolsPackages = Sets.newTreeSet();
        this.myStates = Sets.newHashSet();
        this.myModified = false;
        this.myModificationListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolComponentsPanel.this.refreshModified();
            }
        };
        this.myToolsDetailsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolComponentsPanel.this.updateToolsTable();
            }
        });
    }

    private void updateToolsTable() {
        ((CardLayout)this.myToolsPanel.getLayout()).show(this.myToolsPanel, this.myToolsDetailsCheckbox.isSelected() ? "details" : "summary");
    }

    private void updateToolsItems() {
        PlatformDetailsTreeNode node;
        NodeStateHolder holder;
        this.myToolsDetailsRootNode.removeAllChildren();
        this.myToolsSummaryRootNode.removeAllChildren();
        this.myStates.clear();
        HashSet buildToolsNodes = Sets.newHashSet();
        ParentTreeNode buildToolsParent = new ParentTreeNode(null, null){

            @Override
            public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                renderer.getTextRenderer().append("Android SDK Build Tools");
            }
        };
        for (UpdatablePkgInfo info : this.myBuildToolsPackages) {
            holder = new NodeStateHolder(info);
            this.myStates.add(holder);
            node = new PlatformDetailsTreeNode(holder, this.myIncludePreview, this.myModificationListener);
            buildToolsParent.add(node);
            buildToolsNodes.add(node);
        }
        this.myToolsDetailsRootNode.add(buildToolsParent);
        this.myToolsSummaryRootNode.add(new BuildToolsSummaryTreeNode(buildToolsNodes, this.myIncludePreview));
        for (UpdatablePkgInfo info : this.myToolsPackages) {
            holder = new NodeStateHolder(info);
            this.myStates.add(holder);
            node = new PlatformDetailsTreeNode(holder, this.myIncludePreview, this.myModificationListener);
            this.myToolsDetailsRootNode.add(node);
            if (info.getPkgDesc(this.myIncludePreview).isObsolete()) continue;
            this.myToolsSummaryRootNode.add(new PlatformDetailsTreeNode(holder, this.myIncludePreview, this.myModificationListener));
        }
        this.refreshModified();
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myToolsDetailTable);
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myToolsSummaryTable);
        this.myToolsDetailTable.updateUI();
        this.myToolsSummaryTable.updateUI();
        TreeUtil.expandAll((JTree)this.myToolsDetailTable.getTree());
        TreeUtil.expandAll((JTree)this.myToolsSummaryTable.getTree());
    }

    public void setPackages(Set<UpdatablePkgInfo> toolsPackages, Set<UpdatablePkgInfo> buildToolsPackages) {
        this.myBuildToolsPackages = buildToolsPackages;
        this.myToolsPackages = toolsPackages;
        this.updateToolsItems();
    }

    public void startLoading() {
        this.myToolsPackages.clear();
        this.myBuildToolsPackages.clear();
        this.myToolsLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.updateToolsItems();
        this.myToolsLoadingPanel.setVisible(false);
    }

    public void reset() {
        Enumeration<TreeNode> children = this.myToolsDetailsRootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)children.nextElement();
            node.resetState();
        }
        this.refreshModified();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void refreshModified() {
        Enumeration<TreeNode> items = this.myToolsDetailsRootNode.breadthFirstEnumeration();
        while (items.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)items.nextElement();
            if (node.getInitialState() == node.getCurrentState()) continue;
            this.myModified = true;
            return;
        }
        this.myModified = false;
    }

    private void createUIComponents() {
        this.myToolsLoadingIcon = new AsyncProcessIcon("Loading...");
        this.myToolsSummaryRootNode = new RootNode();
        this.myToolsDetailsRootNode = new RootNode();
        UpdaterTreeNode.Renderer renderer = new UpdaterTreeNode.Renderer();
        ColumnInfo[] toolsSummaryColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new VersionColumnInfo(), new StatusColumnInfo()};
        this.myToolsSummaryTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myToolsSummaryRootNode, toolsSummaryColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myToolsSummaryTable, renderer, this.myModificationListener);
        ColumnInfo[] toolsDetailColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new VersionColumnInfo(), new StatusColumnInfo()};
        this.myToolsDetailTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myToolsDetailsRootNode, toolsDetailColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myToolsDetailTable, renderer, this.myModificationListener);
    }

    public void clearState() {
        this.myStates.clear();
    }

    public void setIncludePreview(boolean includePreview) {
        this.myIncludePreview = includePreview;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>Below are the available SDK developer tools. Once installed, Android Studio will automatically check for updates. Check \"show package details\" to display available versions of an SDK Tool.</html>");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        this.myToolsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, "summary");
        TreeTableView treeTableView = this.myToolsSummaryTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, "details");
        TreeTableView treeTableView2 = this.myToolsDetailTable;
        jBScrollPane2.setViewportView((Component)treeTableView2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null));
        this.myToolsDetailsCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show Package Details");
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 4, 0, 7, 0, null, null, null));
        this.myToolsLoadingPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Looking for updates...");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myToolsLoadingIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

