/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.sdk.LogWrapper;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.internal.sources.SdkAddonSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSourceCategory;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSources;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSysImgSource;
import com.android.tools.idea.updater.configure.EditSourceDialog;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class SourcesTableModel
extends ListTableModel<Row>
implements EditableModel {
    private SdkSources mySources;
    private Map<String, SdkSource> myInitialItems = Maps.newHashMap();
    private SdkState mySdkState;
    private Map<String, Boolean> myUrlEnabledMap = Maps.newHashMap();

    SourcesTableModel() {
        super(new ColumnInfo[0]);
        this.setColumnInfos(new ColumnInfo[]{new ColumnInfo<Row, Boolean>("Enabled"){

            public Boolean valueOf(Row row) {
                return row.myEnabled;
            }

            public int getWidth(JTable table) {
                return 60;
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public boolean isCellEditable(Row row) {
                return Strings.isNullOrEmpty((String)row.mySource.getFetchError());
            }

            public void setValue(Row row, Boolean value) {
                row.myEnabled = value;
                row.mySource.setEnabled(value.booleanValue());
                SourcesTableModel.this.myUrlEnabledMap.put(row.mySource.getUrl(), value);
                SourcesTableModel.this.mySources.notifyChangeListeners();
            }

            public TableCellRenderer getRenderer(final Row row) {
                String error = row.mySource.getFetchError();
                if (!Strings.isNullOrEmpty((String)error)) {
                    return new IconTableCellRenderer<Boolean>(){

                        protected Icon getIcon(Boolean value, JTable table, int row2) {
                            return AllIcons.General.Error;
                        }

                        public String getText() {
                            return null;
                        }

                        public String getToolTipText() {
                            return row.mySource.getFetchError();
                        }

                        public int getHorizontalAlignment() {
                            return 0;
                        }
                    };
                }
                return super.getRenderer((Object)row);
            }
        }, new ColumnInfo<Row, String>("Name"){

            public String valueOf(Row r) {
                return r.mySource.getUiName();
            }
        }, new ColumnInfo<Row, String>("URL"){

            public String valueOf(Row r) {
                return r.mySource.getUrl();
            }
        }});
    }

    public void setSourceEnabled(int i, boolean enabled) {
        Row r = (Row)this.getItem(i);
        r.myEnabled = enabled;
        this.myUrlEnabledMap.put(r.mySource.getUrl(), enabled);
        this.fireTableRowsUpdated(i, i);
        this.mySources.notifyChangeListeners();
    }

    public void setSdkState(SdkState state) {
        this.mySdkState = state;
        this.mySources = state.getRemoteSdk().fetchSources(86400000L, (ILogger)new LogWrapper(Logger.getInstance(((Object)((Object)this)).getClass())));
        for (SdkSource s : this.mySources.getAllSources()) {
            this.myInitialItems.put(s.getUrl(), s);
        }
        this.refreshSources();
    }

    public void refreshSources() {
        ArrayList items = Lists.newArrayList();
        for (SdkSource source : this.mySources.getAllSources()) {
            Boolean enabled = this.myUrlEnabledMap.get(source.getUrl());
            if (enabled == null) {
                enabled = source.isEnabled();
                this.myUrlEnabledMap.put(source.getUrl(), enabled);
            }
            items.add(new Row(source, enabled));
        }
        this.setItems(items);
    }

    public void editRow(int index) {
        Row r = (Row)this.getRowValue(index);
        EditSourceDialog input = this.showEditDialog(r.mySource);
        if (input.isOK()) {
            this.removeRow(index);
            this.createSource(input.getUrl(), input.getUiName());
        }
    }

    public void addRow() {
        EditSourceDialog input = this.showEditDialog(null);
        if (input.isOK()) {
            this.createSource(input.getUrl(), input.getUiName());
        }
    }

    private EditSourceDialog showEditDialog(SdkSource source) {
        EditSourceDialog input = new EditSourceDialog(this.mySources, source);
        input.show();
        return input;
    }

    private void createSource(String url, String uiName) {
        Object newSource = url.endsWith("sys-img.xml") ? new SdkSysImgSource(url, uiName) : new SdkAddonSource(url, uiName);
        this.mySources.add(SdkSourceCategory.USER_ADDONS, (SdkSource)newSource);
        this.mySources.notifyChangeListeners();
    }

    public void removeRow(int idx) {
        this.mySources.remove(((Row)this.getRowValue((int)idx)).mySource);
        super.removeRow(idx);
        this.mySources.notifyChangeListeners();
    }

    public void exchangeRows(int oldIndex, int newIndex) {
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public boolean isEditable(int row) {
        return Sets.newHashSet((Object[])this.mySources.getSources(SdkSourceCategory.USER_ADDONS)).contains(((Row)this.getRowValue((int)row)).mySource);
    }

    public void reset() {
        if (this.isSourcesModified()) {
            this.mySources.loadUserAddons((ILogger)new StdLogger(StdLogger.Level.WARNING));
        }
        for (Row row : this.getItems()) {
            row.myEnabled = row.mySource.isEnabled();
        }
        this.refreshSources();
    }

    public boolean isSourcesModified() {
        if (this.getItems().size() != this.myInitialItems.size()) {
            return true;
        }
        for (Row row : this.getItems()) {
            SdkSource orig = this.myInitialItems.get(row.mySource.getUrl());
            if (orig != null && Objects.equal((Object)orig.getUiName(), (Object)row.mySource.getUiName()) && orig.isEnabled() == row.myEnabled) continue;
            return true;
        }
        return false;
    }

    public void save() {
        if (this.isSourcesModified()) {
            this.mySources.saveUserAddons((ILogger)new StdLogger(StdLogger.Level.WARNING));
            for (Row row : this.getItems()) {
                row.mySource.setEnabled(row.myEnabled);
            }
        }
    }

    protected static class Row
    implements SdkUpdaterConfigPanel.MultiStateRow {
        SdkSource mySource;
        boolean myEnabled;

        public Row(SdkSource source, boolean enabled) {
            this.mySource = source;
            this.myEnabled = enabled;
        }

        @Override
        public void cycleState() {
            this.myEnabled = !this.myEnabled;
        }
    }
}

