/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.sdk.DispatchRunnable;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.LogWrapper;
import com.android.tools.idea.sdk.SdkLoadedCallback;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSources;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.updater.configure.CheckboxClickListener;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.PlatformComponentsPanel;
import com.android.tools.idea.updater.configure.ToolComponentsPanel;
import com.android.tools.idea.updater.configure.UpdateSitesPanel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.wizard.ConsolidatedProgressStep;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import sun.awt.CausedFocusEvent;

public class SdkUpdaterConfigPanel {
    private JPanel myRootPane;
    private JTextField mySdkLocation;
    private PlatformComponentsPanel myPlatformComponentsPanel;
    private ToolComponentsPanel myToolComponentsPanel;
    private UpdateSitesPanel myUpdateSitesPanel;
    private HyperlinkLabel myLaunchStandaloneLink;
    private HyperlinkLabel myChannelLink;
    private HyperlinkLabel myEditSdkLink;
    private JBTabbedPane myTabPane;
    private JPanel mySdkLocationPanel;
    private JBLabel mySdkLocationLabel;
    private JBLabel mySdkErrorLabel;
    private SdkSources mySdkSources;
    private Runnable mySourcesChangeListener;
    private SdkState mySdkState;
    private boolean myHasPreview;
    private boolean myIncludePreview;
    SdkLoadedCallback myUpdater;

    public SdkUpdaterConfigPanel(SdkState sdkState, final Runnable channelChangedCallback) {
        this.$$$setupUI$$$();
        this.mySourcesChangeListener = new DispatchRunnable(){

            public void doRun() {
                SdkUpdaterConfigPanel.this.refresh();
            }
        };
        this.myUpdater = new SdkLoadedCallback(true){

            public void doRun(SdkPackages packages) {
                SdkUpdaterConfigPanel.this.updateItems(packages);
            }
        };
        UsageTracker.getInstance().trackEvent("sdkManager", "sdkManagerLoaded", null, null);
        this.mySdkState = sdkState;
        LogWrapper logger = new LogWrapper(Logger.getInstance(this.getClass()));
        this.mySdkSources = this.mySdkState.getRemoteSdk().fetchSources(86400000L, (ILogger)logger);
        this.mySdkSources.addChangeListener(this.mySourcesChangeListener);
        this.myUpdateSitesPanel.setSdkState(sdkState);
        this.myLaunchStandaloneLink.setHyperlinkText("Launch Standalone SDK Manager");
        this.myLaunchStandaloneLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                RunAndroidSdkManagerAction.runSpecificSdkManager(null, (File)IdeSdks.getAndroidSdkPath());
            }
        });
        this.myChannelLink.setHyperlinkText("Preview packages available! ", "Switch", " to Preview Channel to see them");
        this.myChannelLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                UpdateSettingsConfigurable settings = new UpdateSettingsConfigurable();
                settings.setCheckNowEnabled(false);
                ShowSettingsUtil.getInstance().editConfigurable((Component)SdkUpdaterConfigPanel.this.getComponent(), (Configurable)settings);
                channelChangedCallback.run();
            }
        });
        this.myEditSdkLink.setHyperlinkText("Edit");
        this.myEditSdkLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                DialogWrapperHost host = new DialogWrapperHost(null);
                DynamicWizard wizard = new DynamicWizard(null, null, "SDK Setup", (DynamicWizardHost)host, (DynamicWizardHost)host){
                    final /* synthetic */ DynamicWizardHost val$host;
                    {
                        this.val$host = dynamicWizardHost;
                        super(x0, x1, x2, x3);
                    }

                    public void init() {
                        ConsolidatedProgressStep progressStep = new ConsolidatedProgressStep(this.myHost.getDisposable(), this.val$host);
                        String sdkPath = SdkUpdaterConfigPanel.this.mySdkLocation.getText();
                        File location = StringUtil.isEmpty((String)sdkPath) ? FirstRunWizardDefaults.getInitialSdkLocation((FirstRunWizardMode)FirstRunWizardMode.MISSING_SDK) : new File(sdkPath);
                        InstallComponentsPath path = new InstallComponentsPath((ProgressStep)progressStep, FirstRunWizardMode.MISSING_SDK, location, SdkUpdaterConfigPanel.this.mySdkState.getPackages().getRemotePkgInfos(), false);
                        progressStep.setPaths((List)Lists.newArrayList((Object[])new InstallComponentsPath[]{path}));
                        this.addPath((AndroidStudioWizardPath)path);
                        this.addPath((AndroidStudioWizardPath)new SingleStepPath((DynamicWizardStep)progressStep));
                        super.init();
                    }

                    public void performFinishingActions() {
                        final File newPath = IdeSdks.getAndroidSdkPath();
                        if (newPath != null) {
                            SdkUpdaterConfigPanel.this.mySdkState = SdkState.getInstance((AndroidSdkData)AndroidSdkData.getSdkData((File)newPath));
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SdkUpdaterConfigPanel.this.mySdkLocation.setText(newPath.getAbsolutePath());
                                    SdkUpdaterConfigPanel.this.refresh();
                                }
                            });
                        }
                    }

                    protected String getProgressTitle() {
                        return "Setting up SDK...";
                    }

                    protected String getWizardActionDescription() {
                        return "Setting up SDK...";
                    }
                };
                wizard.init();
                wizard.show();
            }
        });
        this.mySdkLocation.setEditable(false);
        this.mySdkErrorLabel.setIcon(AllIcons.General.BalloonError);
        this.mySdkErrorLabel.setForeground((Color)JBColor.RED);
    }

    public void setIncludePreview(boolean includePreview) {
        this.myIncludePreview = includePreview;
        this.myChannelLink.setVisible(this.myHasPreview && !this.myIncludePreview);
        this.myPlatformComponentsPanel.setIncludePreview(includePreview);
        this.myToolComponentsPanel.setIncludePreview(includePreview);
        this.loadPackages(this.mySdkState.getPackages());
    }

    public JComponent getComponent() {
        return this.myRootPane;
    }

    public boolean isModified() {
        return this.myPlatformComponentsPanel.isModified() || this.myToolComponentsPanel.isModified() || this.myUpdateSitesPanel.isModified();
    }

    static void setTreeTableProperties(TreeTableView tt, UpdaterTreeNode.Renderer renderer, ChangeListener listener) {
        tt.setTreeCellRenderer((TreeCellRenderer)renderer);
        new CheckboxClickListener(tt, renderer).installOn((Component)tt);
        TreeUtil.installActions((JTree)tt.getTree());
        tt.getTree().setToggleClickCount(0);
        tt.getTree().setShowsRootHandles(true);
        SdkUpdaterConfigPanel.setTableProperties((JTable)tt, listener);
    }

    static void setTableProperties(final JTable table, final ChangeListener listener) {
        assert (table instanceof SelectionProvider);
        ActionMap am = table.getActionMap();
        final CycleAction forwardAction = new CycleAction(false);
        final CycleAction backwardAction = new CycleAction(true);
        am.put("selectPreviousColumnCell", backwardAction);
        am.put("selectNextColumnCell", forwardAction);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                    List selection = (List)((SelectionProvider)table).getSelection();
                    for (MultiStateRow node : selection) {
                        node.cycleState();
                        table.repaint();
                        if (listener == null) continue;
                        listener.stateChanged(new ChangeEvent(node));
                    }
                }
            }
        });
        table.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != null) {
                    table.getSelectionModel().clearSelection();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                JTable table2 = (JTable)e.getSource();
                if (table2.getSelectionModel().getMinSelectionIndex() != -1) {
                    return;
                }
                if (e instanceof CausedFocusEvent && ((CausedFocusEvent)e).getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD) {
                    backwardAction.doAction(table2);
                } else {
                    forwardAction.doAction(table2);
                }
            }
        });
    }

    protected static void resizeColumnsToFit(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 1; column < table.getColumnCount(); ++column) {
            int width = 50;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component comp = table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            columnModel.getColumn(column).setPreferredWidth(width);
        }
    }

    public void refresh() {
        this.validate();
        this.myPlatformComponentsPanel.startLoading();
        this.myToolComponentsPanel.startLoading();
        this.myUpdateSitesPanel.startLoading();
        SdkLoadedCallback remoteComplete = new SdkLoadedCallback(true){

            public void doRun(SdkPackages packages) {
                SdkUpdaterConfigPanel.this.updateItems(packages);
                SdkUpdaterConfigPanel.this.myPlatformComponentsPanel.finishLoading();
                SdkUpdaterConfigPanel.this.myToolComponentsPanel.finishLoading();
                SdkUpdaterConfigPanel.this.myUpdateSitesPanel.finishLoading();
            }
        };
        this.mySdkState.loadAsync(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, this.myUpdater, remoteComplete, null, true);
    }

    private void validate() {
        AndroidSdkData data = this.mySdkState.getSdkData();
        File sdkLocation = null;
        if (data != null) {
            sdkLocation = data.getLocation();
        }
        WizardUtils.ValidationResult result = WizardUtils.validateLocation((String)(sdkLocation != null ? sdkLocation.getAbsolutePath() : null), (String)"Android SDK Location", (boolean)false);
        this.myTabPane.setEnabled(!result.isError());
        this.myPlatformComponentsPanel.setEnabled(!result.isError());
        this.mySdkLocationLabel.setForeground(result.isOk() ? JBColor.foreground() : JBColor.RED);
        this.mySdkErrorLabel.setVisible(!result.isOk());
        if (!result.isOk()) {
            this.mySdkErrorLabel.setText(result.getFormattedMessage());
        }
    }

    private void loadPackages(SdkPackages packages) {
        TreeMultimap platformPackages = TreeMultimap.create();
        TreeSet buildToolsPackages = Sets.newTreeSet();
        TreeSet toolsPackages = Sets.newTreeSet();
        for (UpdatablePkgInfo info : packages.getConsolidatedPkgs().values()) {
            IPkgDesc desc = info.getPkgDesc(this.myIncludePreview);
            if (desc == null) continue;
            AndroidVersion version = desc.getAndroidVersion();
            PkgType type = info.getPkgDesc(this.myIncludePreview).getType();
            if (type == PkgType.PKG_SAMPLE) continue;
            if (version != null && type != PkgType.PKG_DOC) {
                platformPackages.put((Object)version, (Object)info);
            } else if (type == PkgType.PKG_BUILD_TOOLS) {
                buildToolsPackages.add(info);
            } else {
                toolsPackages.add(info);
            }
            if (!info.hasPreview()) continue;
            this.myHasPreview = true;
        }
        this.myChannelLink.setVisible(this.myHasPreview && !this.myIncludePreview);
        this.myPlatformComponentsPanel.setPackages((Multimap<AndroidVersion, UpdatablePkgInfo>)platformPackages);
        this.myToolComponentsPanel.setPackages(toolsPackages, buildToolsPackages);
    }

    private void updateItems(SdkPackages packages) {
        this.myPlatformComponentsPanel.clearState();
        this.myToolComponentsPanel.clearState();
        this.loadPackages(packages);
    }

    public Collection<NodeStateHolder> getStates() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myPlatformComponentsPanel.myStates);
        result.addAll(this.myToolComponentsPanel.myStates);
        return result;
    }

    public void reset() {
        this.refresh();
        File path = IdeSdks.getAndroidSdkPath();
        if (path != null) {
            this.mySdkLocation.setText(path.getPath());
        }
        this.myPlatformComponentsPanel.reset();
        this.myToolComponentsPanel.reset();
        this.myUpdateSitesPanel.reset();
    }

    public void disposeUIResources() {
        this.mySdkSources.removeChangeListener(this.mySourcesChangeListener);
    }

    public void saveSources() {
        this.myUpdateSitesPanel.save();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel hyperlinkLabel2;
        UpdateSitesPanel updateSitesPanel;
        ToolComponentsPanel toolComponentsPanel;
        PlatformComponentsPanel platformComponentsPanel;
        JBTabbedPane jBTabbedPane;
        JBLabel jBLabel;
        HyperlinkLabel hyperlinkLabel3;
        JBLabel jBLabel2;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Manager for the Android SDK and Tools used by Android Studio");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.mySdkLocationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        this.mySdkLocation = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(400, -1), null, null));
        this.mySdkLocationLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Android SDK Location:");
        jBLabel2.setEnabled(true);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEditSdkLink = hyperlinkLabel3 = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, null, null));
        this.mySdkErrorLabel = jBLabel = new JBLabel();
        jBLabel.setText("SDK Location must be set");
        jBLabel.setVisible(false);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTabPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Platforms", null, jPanel3, null);
        this.myPlatformComponentsPanel = platformComponentsPanel = new PlatformComponentsPanel();
        JComponent jComponent = platformComponentsPanel.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Tools", null, jPanel4, null);
        this.myToolComponentsPanel = toolComponentsPanel = new ToolComponentsPanel();
        JComponent jComponent2 = toolComponentsPanel.$$$getRootComponent$$$();
        jPanel4.add((Component)jComponent2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Update Sites", null, jPanel5, null);
        this.myUpdateSitesPanel = updateSitesPanel = new UpdateSitesPanel();
        JComponent jComponent3 = updateSitesPanel.$$$getRootComponent$$$();
        jPanel5.add((Component)jComponent3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLaunchStandaloneLink = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel2.add((Component)hyperlinkLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myChannelLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setVisible(false);
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }

    private static class CycleAction
    extends AbstractAction {
        boolean myBackward;

        CycleAction(boolean backward) {
            this.myBackward = backward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.doAction((JTable)evt.getSource());
        }

        public void doAction(JTable table) {
            int row;
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ListSelectionModel selectionModel = table.getSelectionModel();
            int n = row = this.myBackward ? selectionModel.getMinSelectionIndex() : selectionModel.getMaxSelectionIndex();
            if (row == -1 && this.myBackward) {
                row = table.getRowCount();
            }
            if ((row += this.myBackward ? -1 : 1) < 0) {
                manager.focusPreviousComponent(table);
            } else if (row >= table.getRowCount()) {
                manager.focusNextComponent(table);
            } else {
                selectionModel.setSelectionInterval(row, row);
                table.setColumnSelectionInterval(1, 1);
                table.scrollRectToVisible(table.getCellRect(row, 1, true));
            }
            table.repaint();
        }
    }

    public static interface MultiStateRow {
        public void cycleState();
    }
}

