/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePlatformPkgInfo;
import com.android.tools.idea.updater.configure.ApiLevelColumnInfo;
import com.android.tools.idea.updater.configure.DownloadStatusColumnInfo;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.ParentTreeNode;
import com.android.tools.idea.updater.configure.PlatformDetailsTreeNode;
import com.android.tools.idea.updater.configure.RevisionColumnInfo;
import com.android.tools.idea.updater.configure.RootNode;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.StatusColumnInfo;
import com.android.tools.idea.updater.configure.SummaryTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;

public class PlatformComponentsPanel {
    private TreeTableView myPlatformSummaryTable;
    private TreeTableView myPlatformDetailTable;
    private JPanel myPlatformPanel;
    private JCheckBox myPlatformDetailsCheckbox;
    private JPanel myPlatformLoadingPanel;
    private JBLabel myPlatformLoadingLabel;
    private AsyncProcessIcon myPlatformLoadingIcon;
    private JPanel myRootPanel;
    private boolean myModified;
    private boolean myIncludePreview;
    private UpdaterTreeNode myPlatformDetailsRootNode;
    private UpdaterTreeNode myPlatformSummaryRootNode;
    Set<NodeStateHolder> myStates;
    Multimap<AndroidVersion, UpdatablePkgInfo> myCurrentPackages;
    private final ChangeListener myModificationListener;

    public PlatformComponentsPanel() {
        this.$$$setupUI$$$();
        this.myStates = Sets.newHashSet();
        this.myCurrentPackages = TreeMultimap.create();
        this.myModificationListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlatformComponentsPanel.this.refreshModified();
            }
        };
        this.myPlatformSummaryTable.setColumnSelectionAllowed(false);
        this.myPlatformLoadingLabel.setForeground((Color)JBColor.GRAY);
        this.myPlatformDetailsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlatformComponentsPanel.this.updatePlatformTable();
            }
        });
    }

    private void updatePlatformTable() {
        ((CardLayout)this.myPlatformPanel.getLayout()).show(this.myPlatformPanel, this.myPlatformDetailsCheckbox.isSelected() ? "details" : "summary");
    }

    private void updatePlatformItems() {
        this.myPlatformDetailsRootNode.removeAllChildren();
        this.myPlatformSummaryRootNode.removeAllChildren();
        this.myStates.clear();
        List versions = Lists.newArrayList((Iterable)this.myCurrentPackages.keySet());
        versions = Lists.reverse((List)versions);
        for (AndroidVersion version : versions) {
            SummaryTreeNode node;
            String androidVersion = null;
            for (UpdatablePkgInfo info : this.myCurrentPackages.get((Object)version)) {
                String maybeVersion = null;
                if (info.hasLocal()) {
                    maybeVersion = info.getLocalInfo().getSourceProperties().getProperty("Platform.Version");
                } else {
                    RemotePkgInfo remote = info.getRemote(true);
                    if (remote instanceof RemotePlatformPkgInfo) {
                        maybeVersion = ((RemotePlatformPkgInfo)remote).getVersionName();
                    }
                }
                if (maybeVersion == null) continue;
                androidVersion = maybeVersion;
            }
            HashSet versionNodes = Sets.newHashSet();
            ParentTreeNode marker = new ParentTreeNode(version, androidVersion);
            this.myPlatformDetailsRootNode.add(marker);
            boolean obsolete = false;
            for (UpdatablePkgInfo info : this.myCurrentPackages.get((Object)version)) {
                NodeStateHolder holder = new NodeStateHolder(info);
                this.myStates.add(holder);
                PlatformDetailsTreeNode node2 = new PlatformDetailsTreeNode(holder, this.myIncludePreview, this.myModificationListener);
                marker.add(node2);
                versionNodes.add(node2);
                if (!info.getPkgDesc(this.myIncludePreview).isObsolete() || info.getPkgDesc(this.myIncludePreview).getType() != PkgType.PKG_PLATFORM) continue;
                obsolete = true;
            }
            if (obsolete || (node = SummaryTreeNode.createNode(version, versionNodes, androidVersion)) == null) continue;
            this.myPlatformSummaryRootNode.add(node);
        }
        this.refreshModified();
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformDetailTable);
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformSummaryTable);
        this.myPlatformDetailTable.updateUI();
        this.myPlatformSummaryTable.updateUI();
        TreeUtil.expandAll((JTree)this.myPlatformDetailTable.getTree());
        TreeUtil.expandAll((JTree)this.myPlatformSummaryTable.getTree());
    }

    public void startLoading() {
        this.myCurrentPackages.clear();
        this.myPlatformLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.updatePlatformItems();
        this.myPlatformLoadingPanel.setVisible(false);
    }

    private void createUIComponents() {
        UpdaterTreeNode.Renderer renderer = new UpdaterTreeNode.Renderer();
        this.myPlatformLoadingIcon = new AsyncProcessIcon("Loading...");
        this.myPlatformSummaryRootNode = new RootNode();
        this.myPlatformDetailsRootNode = new RootNode();
        ColumnInfo[] platformSummaryColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformSummaryTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformSummaryRootNode, platformSummaryColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformSummaryTable, renderer, this.myModificationListener);
        ColumnInfo[] platformDetailColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformDetailTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformDetailsRootNode, platformDetailColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformDetailTable, renderer, this.myModificationListener);
    }

    public void setPackages(Multimap<AndroidVersion, UpdatablePkgInfo> packages) {
        this.myCurrentPackages = packages;
        this.updatePlatformItems();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void refreshModified() {
        Enumeration<TreeNode> items = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (items.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)items.nextElement();
            if (node.getInitialState() == node.getCurrentState()) continue;
            this.myModified = true;
            return;
        }
        this.myModified = false;
    }

    public void reset() {
        Enumeration<TreeNode> children = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)children.nextElement();
            node.resetState();
        }
        this.refreshModified();
    }

    public void clearState() {
        this.myStates.clear();
    }

    public void setIncludePreview(boolean includePreview) {
        this.myIncludePreview = includePreview;
    }

    public void setEnabled(boolean enabled) {
        this.myPlatformDetailTable.setEnabled(enabled);
        this.myPlatformSummaryTable.setEnabled(enabled);
        this.myPlatformDetailsCheckbox.setEnabled(enabled);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPlatformDetailsCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show Package Details");
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 4, 0, 7, 0, null, null, null));
        this.myPlatformLoadingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPlatformLoadingLabel = jBLabel = new JBLabel();
        jBLabel.setText("Looking for updates...");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myPlatformLoadingIcon;
        jPanel2.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html>Each Android SDK Platform package includes the Android platform and sources pertaining to an API level by default. Once installed, Android Studio will automatically check for updates. Check \"show package details\" to display individual SDK components.</html>");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        this.myPlatformPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "summary");
        TreeTableView treeTableView = this.myPlatformSummaryTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, "details");
        TreeTableView treeTableView2 = this.myPlatformDetailTable;
        jBScrollPane2.setViewportView((Component)treeTableView2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

