/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.AsyncReceive;
import org.gradle.messaging.dispatch.DelayedReceive;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.gradle.messaging.dispatch.FailureHandlingDispatch;
import org.gradle.messaging.dispatch.QueuingDispatch;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolStack<T>
implements AsyncStoppable {
    private final AsyncDispatch<Runnable> workQueue;
    private final QueuingDispatch<T> incomingQueue = new QueuingDispatch();
    private final QueuingDispatch<T> outgoingQueue = new QueuingDispatch();
    private final AsyncReceive<Runnable> receiver;
    private final DelayedReceive<Runnable> callbackQueue;
    private final LinkedList<Stage> stack = new LinkedList();
    private final LinkedList<Runnable> contextQueue = new LinkedList();
    private final DispatchFailureHandler<? super T> outgoingDispatchFailureHandler;
    private final DispatchFailureHandler<? super T> incomingDispatchFailureHandler;
    private final CountDownLatch protocolsStopped;
    private final AtomicBoolean stopRequested = new AtomicBoolean();
    private final AsyncConnection<T> bottomConnection;
    private final AsyncConnection<T> topConnection;

    public ProtocolStack(Executor executor, DispatchFailureHandler<? super T> outgoingDispatchFailureHandler, DispatchFailureHandler<? super T> incomingDispatchFailureHandler, Protocol<T> ... protocols) {
        this.outgoingDispatchFailureHandler = outgoingDispatchFailureHandler;
        this.incomingDispatchFailureHandler = incomingDispatchFailureHandler;
        this.callbackQueue = new DelayedReceive((TimeProvider)new TrueTimeProvider());
        this.protocolsStopped = new CountDownLatch(protocols.length);
        this.workQueue = new AsyncDispatch(executor);
        this.workQueue.dispatchTo(new ExecuteRunnable());
        this.stack.add(new TopStage());
        for (Protocol<T> protocol : protocols) {
            this.stack.add(new ProtocolStage(protocol));
        }
        this.stack.add(new BottomStage());
        for (int i = 0; i < this.stack.size(); ++i) {
            Stage context = this.stack.get(i);
            Stage outgoingStage = i == this.stack.size() - 1 ? null : this.stack.get(i + 1);
            Stage incomingStage = i == 0 ? null : this.stack.get(i - 1);
            context.attach(outgoingStage, incomingStage);
        }
        this.receiver = new AsyncReceive(executor);
        this.receiver.dispatchTo(this.workQueue);
        this.receiver.receiveFrom(this.callbackQueue);
        this.bottomConnection = new BottomConnection();
        this.topConnection = new TopConnection();
        this.workQueue.dispatch(new Runnable(){

            public void run() {
                for (int i = ProtocolStack.this.stack.size() - 1; i >= 0; --i) {
                    Stage context = (Stage)ProtocolStack.this.stack.get(i);
                    context.start();
                }
            }
        });
    }

    public AsyncConnection<T> getBottom() {
        return this.bottomConnection;
    }

    public AsyncConnection<T> getTop() {
        return this.topConnection;
    }

    public void requestStop() {
        if (!this.stopRequested.getAndSet(true)) {
            this.workQueue.dispatch(new Runnable(){

                public void run() {
                    ((Stage)ProtocolStack.this.stack.getFirst()).requestStop();
                }
            });
        }
    }

    public void stop() {
        this.requestStop();
        try {
            this.protocolsStopped.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.callbackQueue.clear();
        CompositeStoppable.stoppable((Object[])new Object[]{this.callbackQueue, this.receiver, this.workQueue, this.incomingQueue, this.outgoingQueue}).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TopConnection
    implements AsyncConnection<T> {
        private TopConnection() {
        }

        @Override
        public void dispatchTo(Dispatch<? super T> handler) {
            ProtocolStack.this.incomingQueue.dispatchTo(new FailureHandlingDispatch(handler, ProtocolStack.this.incomingDispatchFailureHandler));
        }

        @Override
        public void dispatch(final T message) {
            ProtocolStack.this.workQueue.dispatch(new Runnable(){

                public String toString() {
                    return String.format("outgoing %s", message);
                }

                public void run() {
                    ((Stage)ProtocolStack.this.stack.getFirst()).handleOutgoing(message);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BottomConnection
    implements AsyncConnection<T> {
        private BottomConnection() {
        }

        @Override
        public void dispatchTo(Dispatch<? super T> handler) {
            ProtocolStack.this.outgoingQueue.dispatchTo(new FailureHandlingDispatch(handler, ProtocolStack.this.outgoingDispatchFailureHandler));
        }

        @Override
        public void dispatch(final T message) {
            ProtocolStack.this.workQueue.dispatch(new Runnable(){

                public String toString() {
                    return String.format("incoming %s", message);
                }

                public void run() {
                    ((Stage)ProtocolStack.this.stack.getLast()).handleIncoming(message);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BottomStage
    extends Stage {
        private BottomStage() {
        }

        @Override
        public void handleIncoming(T message) {
            this.incoming.handleIncoming(message);
        }

        @Override
        public void handleOutgoing(T message) {
            ProtocolStack.this.outgoingQueue.dispatch(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TopStage
    extends Stage {
        private TopStage() {
        }

        @Override
        public void handleIncoming(T message) {
            ProtocolStack.this.incomingQueue.dispatch(message);
        }

        @Override
        public void handleOutgoing(T message) {
            this.outgoing.handleOutgoing(message);
        }

        @Override
        public void requestStop() {
            this.outgoing.requestStop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProtocolStage
    extends Stage
    implements ProtocolContext<T> {
        private final Protocol<T> protocol;
        private StageState state;

        private ProtocolStage(Protocol<T> protocol) {
            this.state = StageState.Init;
            this.protocol = protocol;
        }

        @Override
        public void start() {
            this.protocol.start(this);
        }

        @Override
        public void handleIncoming(T message) {
            try {
                this.protocol.handleIncoming(message);
            }
            catch (Throwable throwable) {
                ProtocolStack.this.incomingDispatchFailureHandler.dispatchFailed(message, throwable);
            }
        }

        @Override
        public void handleOutgoing(T message) {
            try {
                this.protocol.handleOutgoing(message);
            }
            catch (Throwable throwable) {
                ProtocolStack.this.outgoingDispatchFailureHandler.dispatchFailed(message, throwable);
            }
        }

        @Override
        public void dispatchIncoming(final T message) {
            ProtocolStack.this.contextQueue.add(new Runnable(){

                public void run() {
                    ProtocolStage.this.incoming.handleIncoming(message);
                }
            });
        }

        @Override
        public void dispatchOutgoing(final T message) {
            ProtocolStack.this.contextQueue.add(new Runnable(){

                public void run() {
                    ProtocolStage.this.outgoing.handleOutgoing(message);
                }
            });
        }

        @Override
        public ProtocolContext.Callback callbackLater(int delay, TimeUnit delayUnits, Runnable action) {
            DefaultCallback callback = new DefaultCallback(action);
            ProtocolStack.this.callbackQueue.dispatchLater(callback, delay, delayUnits);
            return callback;
        }

        @Override
        public void stopped() {
            if (this.state == StageState.Init) {
                throw new IllegalStateException(String.format("Cannot stop when in %s state.", new Object[]{this.state}));
            }
            if (this.state != StageState.Stopped) {
                this.state = StageState.Stopped;
                ProtocolStack.this.protocolsStopped.countDown();
                ProtocolStack.this.contextQueue.add(new Runnable(){

                    public void run() {
                        ProtocolStage.this.outgoing.requestStop();
                    }
                });
            }
        }

        @Override
        public void stopLater() {
            if (this.state == StageState.Init || this.state == StageState.Stopped) {
                throw new IllegalStateException(String.format("Cannot stop later when in %s state.", new Object[]{this.state}));
            }
            this.state = StageState.StopPending;
        }

        @Override
        public void requestStop() {
            assert (this.state == StageState.Init);
            this.state = StageState.StopRequested;
            this.protocol.stopRequested();
            if (this.state == StageState.StopRequested) {
                this.stopped();
            }
        }

        private class DefaultCallback
        implements Runnable,
        ProtocolContext.Callback {
            final Runnable action;
            boolean cancelled;

            private DefaultCallback(Runnable action) {
                this.action = action;
            }

            public void cancel() {
                this.cancelled = true;
                ProtocolStack.this.callbackQueue.remove(this);
            }

            public void run() {
                if (!this.cancelled && ProtocolStage.this.state != StageState.Stopped) {
                    this.action.run();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StageState {
        Init,
        StopRequested,
        StopPending,
        Stopped;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Stage {
        protected Stage outgoing;
        protected Stage incoming;

        private Stage() {
        }

        public void attach(Stage outgoing, Stage incoming) {
            this.outgoing = outgoing;
            this.incoming = incoming;
        }

        public void start() {
        }

        public void handleIncoming(T message) {
            throw new UnsupportedOperationException();
        }

        public void handleOutgoing(T message) {
            throw new UnsupportedOperationException();
        }

        public void requestStop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecuteRunnable
    implements Dispatch<Runnable> {
        private ExecuteRunnable() {
        }

        @Override
        public void dispatch(Runnable message) {
            ProtocolStack.this.contextQueue.add(message);
            while (!ProtocolStack.this.contextQueue.isEmpty()) {
                ((Runnable)ProtocolStack.this.contextQueue.removeFirst()).run();
            }
        }
    }
}

