/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.ssh;

import com.glavsoft.transport.Transport;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.CancelConnectionException;
import com.glavsoft.viewer.CancelConnectionQuietlyException;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.ssh.SshKnownHostsManager;
import com.glavsoft.viewer.swing.ssh.SwingSshUserInfo;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SshConnectionManager
implements SshKnownHostsManager {
    public static final String SSH_NODE = "com/glavsoft/viewer/ssh";
    public static final String KNOWN_HOSTS = "known_hosts";
    private Session session;
    private String errorMessage = "";
    private final JFrame parentWindow;
    private JSch jsch;

    public SshConnectionManager(JFrame parentWindow) {
        this.parentWindow = parentWindow;
    }

    public int connect(ConnectionParams connectionParams) throws CancelConnectionException {
        if (Strings.isTrimmedEmpty(connectionParams.sshUserName)) {
            connectionParams.sshUserName = this.getInteractivelySshUserName();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.jsch = new JSch();
        try {
            this.jsch.setKnownHosts(this.getKnownHostsStream());
        }
        catch (JSchException e) {
            String string = String.valueOf(e.getMessage());
            Logger.getLogger(this.getClass().getName()).severe(string.length() != 0 ? "Cannot set JSCH known hosts: ".concat(string) : new String("Cannot set JSCH known hosts: "));
        }
        this.addIdentityFiles();
        int port = 0;
        try {
            this.session = this.jsch.getSession(connectionParams.sshUserName, connectionParams.sshHostName, connectionParams.getSshPortNumber());
            SwingSshUserInfo ui = new SwingSshUserInfo(this.parentWindow);
            this.session.setUserInfo((UserInfo)ui);
            this.session.connect();
            this.sync();
            port = this.session.setPortForwardingL(0, connectionParams.hostName, connectionParams.getPortNumber());
        }
        catch (JSchException e) {
            this.session.disconnect();
            this.errorMessage = e.getMessage();
        }
        return port;
    }

    private void addIdentityFiles() {
        String string = String.valueOf(System.getProperty("user.home"));
        String[] stringArray = String.valueOf(File.separator);
        String dirName = new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(stringArray).length()).append(string).append((String)stringArray).append(".ssh").toString();
        Logger logger = Logger.getLogger(this.getClass().getName());
        for (String fileName : new String[]{"id_rsa", "id_dsa", "identity"}) {
            File keyFile = new File(dirName, fileName);
            if (!keyFile.exists() || !keyFile.isFile()) continue;
            try {
                this.jsch.addIdentity(keyFile.getAbsolutePath());
                String string2 = String.valueOf(keyFile.getAbsolutePath());
                logger.info(string2.length() != 0 ? "Add key file identity: ".concat(string2) : new String("Add key file identity: "));
            }
            catch (JSchException e) {
                String string3 = String.valueOf(keyFile.getAbsolutePath());
                String string4 = String.valueOf(e.getMessage());
                logger.info(new StringBuilder(24 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Cannot add key file '").append(string3).append("' :").append(string4).toString());
            }
        }
    }

    private String getInteractivelySshUserName() throws CancelConnectionException {
        final String[] result = new String[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    result[0] = JOptionPane.showInputDialog(SshConnectionManager.this.parentWindow, "Please enter the user name for SSH connection:", "SSH User Name", 3);
                }
            });
        }
        catch (InterruptedException e) {
            Logger.getLogger(this.getClass().getName()).severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Logger.getLogger(this.getClass().getName()).severe(e.getCause().getMessage());
            e.printStackTrace();
        }
        if (null == result[0]) {
            throw new CancelConnectionQuietlyException("Cancel ssh connection");
        }
        if (Strings.isTrimmedEmpty(result[0])) {
            throw new CancelConnectionException("No Ssh User Name entered");
        }
        return result[0];
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private InputStream getKnownHostsStream() {
        Preferences sshNode = Preferences.userRoot().node(SSH_NODE);
        return new ByteArrayInputStream(sshNode.getByteArray(KNOWN_HOSTS, new byte[0]));
    }

    @Override
    public void sync() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HostKeyRepository repository = this.jsch.getHostKeyRepository();
        try {
            HostKey[] hostKey = repository.getHostKey();
            if (null == hostKey) {
                return;
            }
            for (HostKey hk : hostKey) {
                String host = hk.getHost();
                String type = hk.getType();
                if (type.equals("UNKNOWN")) {
                    this.write(out, host);
                    this.write(out, "\n");
                    continue;
                }
                this.write(out, host);
                this.write(out, " ");
                this.write(out, type);
                this.write(out, " ");
                this.write(out, hk.getKey());
                this.write(out, "\n");
            }
        }
        catch (IOException e) {
            String string = String.valueOf(e.getMessage());
            Logger.getLogger(this.getClass().getName()).severe(string.length() != 0 ? "Cannot sync JSCH known hosts: ".concat(string) : new String("Cannot sync JSCH known hosts: "));
        }
        Preferences sshNode = Preferences.userRoot().node(SSH_NODE);
        sshNode.putByteArray(KNOWN_HOSTS, out.toByteArray());
    }

    private void write(ByteArrayOutputStream out, String str) throws IOException {
        try {
            out.write(str.getBytes(Transport.UTF8));
        }
        catch (UnsupportedEncodingException e) {
            out.write(str.getBytes(Transport.ISO_8859_1));
        }
    }
}

