/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.ui.Formatters;
import com.intellij.execution.junit2.ui.JUnitStatusLine;
import com.intellij.execution.junit2.ui.JUnitTestTreeView;
import com.intellij.execution.junit2.ui.StatisticsPanel;
import com.intellij.execution.junit2.ui.actions.JUnitToolbarPanel;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestStatusLine;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class ConsolePanel
extends TestResultsPanel {
    private static final String PROPORTION_PROPERTY = "test_tree_console_proprtion";
    private static final float DEFAULT_PROPORTION = 0.2f;
    private JUnitStatusLine myStatusLine;
    private StatisticsPanel myStatisticsPanel;
    private TestTreeView myTreeView;
    private TestsOutputConsolePrinter myPrinter;
    private StartingProgress myStartingProgress;

    public ConsolePanel(JComponent console, TestsOutputConsolePrinter printer, JUnitConsoleProperties properties, ExecutionEnvironment environment, AnAction[] consoleActions) {
        super(console, consoleActions, (TestConsoleProperties)properties, environment, PROPORTION_PROPERTY, 0.2f);
        this.myPrinter = printer;
    }

    public void initUI() {
        super.initUI();
        this.myStartingProgress = new StartingProgress((Tree)this.myTreeView);
    }

    protected JComponent createStatisticsPanel() {
        this.myStatisticsPanel = new StatisticsPanel();
        return this.myStatisticsPanel;
    }

    protected ToolbarPanel createToolbarPanel() {
        return new JUnitToolbarPanel(this.myProperties, this.myEnvironment, (JComponent)((Object)this));
    }

    protected TestStatusLine createStatusLine() {
        this.myStatusLine = new JUnitStatusLine();
        return this.myStatusLine;
    }

    protected JComponent createTestTreeView() {
        this.myTreeView = new JUnitTestTreeView();
        return this.myTreeView;
    }

    public void onProcessStarted(ProcessHandler process) {
        this.myStatusLine.onProcessStarted(process);
        if (this.myStartingProgress == null) {
            return;
        }
        this.myStartingProgress.start(process);
    }

    public void setModel(JUnitRunningModel model) {
        this.stopStartingProgress();
        TestTreeView treeView = model.getTreeView();
        treeView.setLargeModel(true);
        this.setLeftComponent((JComponent)treeView);
        this.myToolbarPanel.setModel((TestFrameworkRunningModel)model);
        this.myStatusLine.setModel(model);
        model.addListener(new JUnitAdapter(){

            @Override
            public void onTestSelected(TestProxy test) {
                if (ConsolePanel.this.myPrinter != null) {
                    ConsolePanel.this.myPrinter.updateOnTestSelected((AbstractTestProxy)test);
                }
            }
        });
        this.myStatisticsPanel.attachTo(model);
    }

    private void stopStartingProgress() {
        if (this.myStartingProgress != null) {
            this.myStartingProgress.doStop();
        }
        this.myStartingProgress = null;
    }

    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    public Printer getPrinter() {
        return this.myPrinter;
    }

    public void dispose() {
        this.stopStartingProgress();
        this.myPrinter = null;
    }

    private static class StartingProgress
    implements Runnable {
        private final Alarm myAlarm = new Alarm();
        private final Tree myTree;
        private final DefaultTreeModel myModel;
        private final DefaultMutableTreeNode myRootNode = new DefaultMutableTreeNode();
        private boolean myStarted = false;
        private boolean myStopped = false;
        private final SimpleColoredComponent myStartingLabel;
        private ProcessHandler myProcess;
        private long myStartedAt = System.currentTimeMillis();
        private final ProcessAdapter myProcessListener = new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StartingProgress.this.doStop();
                    }
                });
            }
        };

        public StartingProgress(Tree tree) {
            this.myTree = tree;
            this.myModel = new DefaultTreeModel(this.myRootNode);
            this.myTree.setModel((TreeModel)this.myModel);
            this.myStartingLabel = new SimpleColoredComponent();
            this.myTree.setPaintBusy(true);
            this.myTree.setCellRenderer(new TreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    StartingProgress.this.myStartingLabel.clear();
                    StartingProgress.this.myStartingLabel.setIcon(PoolOfTestIcons.LOADING_ICON);
                    StartingProgress.this.myStartingLabel.append(StartingProgress.this.getProgressText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (!StartingProgress.this.myStarted) {
                        StartingProgress.this.postRepaint();
                    }
                    return StartingProgress.this.myStartingLabel;
                }
            });
            this.myTree.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    StartingProgress.this.myTree.removePropertyChangeListener("model", (PropertyChangeListener)this);
                    StartingProgress.this.doStop();
                }
            });
        }

        private void doStop() {
            this.myStopped = true;
            this.myTree.setPaintBusy(false);
            this.myModel.nodeChanged(this.myRootNode);
            this.myAlarm.cancelAllRequests();
            if (this.myProcess != null) {
                this.myProcess.removeProcessListener((ProcessListener)this.myProcessListener);
            }
            this.myProcess = null;
        }

        @Override
        public void run() {
            this.myModel.nodeChanged(this.myRootNode);
            this.postRepaint();
        }

        private void postRepaint() {
            if (this.myStopped) {
                return;
            }
            this.myStarted = true;
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest((Runnable)this, 300, ModalityState.NON_MODAL);
        }

        public void start(ProcessHandler process) {
            if (process.isProcessTerminated()) {
                return;
            }
            this.myProcess = process;
            this.myStartedAt = System.currentTimeMillis();
            process.addProcessListener((ProcessListener)this.myProcessListener);
        }

        private String getProgressText() {
            if (this.myStopped) {
                return ExecutionBundle.message((String)"test.not.started.progress.text", (Object[])new Object[0]);
            }
            long millis = System.currentTimeMillis() - this.myStartedAt;
            String phaseName = this.myProcess == null ? ExecutionBundle.message((String)"starting.jvm.progress.text", (Object[])new Object[0]) : ExecutionBundle.message((String)"instantiating.tests.progress.text", (Object[])new Object[0]);
            return phaseName + Formatters.printMinSec(millis);
        }
    }
}

