/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.junit2.info.AllInPackageInfo;
import com.intellij.execution.junit2.info.DefaultTestInfo;
import com.intellij.execution.junit2.info.PsiLocator;
import com.intellij.execution.junit2.info.TestCaseInfo;
import com.intellij.execution.junit2.info.TestClassInfo;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public abstract class TestInfo
implements PsiLocator {
    public static final Map<String, Class> KNOWN_PSI_LOCATOR_CLASSES = new HashMap();
    private int myTestCount;

    public static TestInfo readInfoFrom(ObjectReader reader) {
        TestInfo info;
        String testType = reader.readLimitedString();
        Class<DefaultTestInfo> infoClass = KNOWN_PSI_LOCATOR_CLASSES.get(testType);
        if (infoClass == null) {
            infoClass = DefaultTestInfo.class;
        }
        try {
            info = (TestInfo)infoClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        info.readFrom(reader);
        info.setTestCount(reader.readInt());
        return info;
    }

    public boolean shouldRun() {
        return false;
    }

    public int getTestsCount() {
        return this.myTestCount;
    }

    public void setTestCount(int testCount) {
        this.myTestCount = testCount;
    }

    public abstract void readFrom(ObjectReader var1);

    public abstract String getComment();

    public abstract String getName();

    static {
        KNOWN_PSI_LOCATOR_CLASSES.put("TM", TestCaseInfo.class);
        KNOWN_PSI_LOCATOR_CLASSES.put("TC", TestClassInfo.class);
        KNOWN_PSI_LOCATOR_CLASSES.put("TN", AllInPackageInfo.class);
    }
}

