/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.FilterCache;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.TestProxyListener;
import com.intellij.execution.junit2.TestProxyListenersNotifier;
import com.intellij.execution.junit2.events.NewChildEvent;
import com.intellij.execution.junit2.events.StateChangedEvent;
import com.intellij.execution.junit2.events.StatisticsChanged;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.events.TestEventsConsumer;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.junit2.states.ComparisonFailureState;
import com.intellij.execution.junit2.states.IgnoredState;
import com.intellij.execution.junit2.states.Statistics;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TestProxy
extends AbstractTestProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.TestProxy");
    private final TestInfo myInfo;
    private TestState myState = TestState.DEFAULT;
    private final TestProxyListenersNotifier myNotifier = new TestProxyListenersNotifier();
    private Statistics myStatistics = new Statistics();
    private TestEventsConsumer myEventsConsumer;
    private int myPreviousMagnitude = -1;
    private int myStateTimestamp = 0;
    private final FilterCache myChildren = new FilterCache();
    private TestProxy myParent = null;
    public static final Filter NOT_LEAF = Filter.LEAF.not();

    public TestProxy(TestInfo info) {
        this.myInfo = info;
    }

    public String toString() {
        return this.getInfo().getComment() + "." + this.getInfo().getName();
    }

    public TestState getState() {
        return this.myState;
    }

    public void setState(TestState state) {
        if (this.myState != state) {
            if (state.isFinal()) {
                this.addLast(state);
            } else {
                this.fireOnNewPrintable(state);
            }
            if (this.myState != null) {
                state.merge(this.myState, this.getParent());
            }
            this.myState = state;
            this.fireStateChanged();
        }
    }

    public void fireStateChanged() {
        ++this.myStateTimestamp;
        this.pullEvent(new StateChangedEvent(this));
        if (this.myParent != null) {
            this.myParent.onChanged(this);
        }
        this.myNotifier.onChanged(this);
    }

    public int getStateTimestamp() {
        return this.myStateTimestamp;
    }

    public int getChildCount() {
        return this.myChildren.getList().size();
    }

    public List<TestProxy> getChildren() {
        return this.myChildren.getUnmodifiableList();
    }

    public TestProxy getParent() {
        return this.myParent;
    }

    public Navigatable getDescriptor(Location location, TestConsoleProperties testConsoleProperties) {
        return this.getState().getDescriptor(location);
    }

    public String getName() {
        return this.getInfo().getName();
    }

    public boolean isInProgress() {
        return this.getState().isInProgress();
    }

    public boolean isDefect() {
        return this.getState().isDefect();
    }

    public boolean shouldRun() {
        return this.getInfo().shouldRun();
    }

    public int getMagnitude() {
        return this.getState().getMagnitude();
    }

    public Location getLocation(Project project, GlobalSearchScope searchScope) {
        Location location = this.getInfo().getLocation(project, searchScope);
        if (location == null) {
            return this.checkParentParameterized(project, searchScope);
        }
        Location parentLocation = this.getParent().getLocation(project, searchScope);
        if (parentLocation instanceof PsiMemberParameterizedLocation) {
            return new PsiMemberParameterizedLocation(project, location.getPsiElement(), location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : null, ((PsiMemberParameterizedLocation)parentLocation).getParamSetName());
        }
        return location;
    }

    private Location checkParentParameterized(Project project, GlobalSearchScope searchScope) {
        PsiElement parentElement;
        Location parentLocation;
        TestProxy parent = this.getParent();
        if (parent != null && (parentLocation = parent.getLocation(project, searchScope)) != null && (parentElement = parentLocation.getPsiElement()) instanceof PsiClass) {
            return PsiMemberParameterizedLocation.getParameterizedLocation((PsiClass)((PsiClass)parentElement), (String)this.getInfo().getName());
        }
        return null;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isInterrupted() {
        return this.getMagnitude() == 4;
    }

    public boolean isIgnored() {
        return this.myState instanceof IgnoredState;
    }

    public boolean isPassed() {
        return this.getMagnitude() <= 1;
    }

    public void addChild(TestProxy child) {
        this.addChild(child, -1);
    }

    public void addChild(TestProxy child, int idx) {
        if (this.myChildren.contains(child)) {
            return;
        }
        if (child.getParent() != null) {
            return;
        }
        this.myChildren.insert(child, idx);
        child.myParent = this;
        this.addLast((Printable)child);
        child.setPrinter(this.myPrinter);
        this.pullEvent(new NewChildEvent(this, child));
        this.getState().changeStateAfterAddingChildTo(this, child);
        this.myNotifier.onChildAdded(this, child);
    }

    public void insertNextRunningChild(TestProxy child) {
        int idx = -1;
        List<TestProxy> list = this.myChildren.getList();
        for (int i = 0; i < list.size(); ++i) {
            TestProxy proxy = list.get(i);
            if (proxy.getState().isFinal()) continue;
            idx = i;
            break;
        }
        this.addChild(child, idx);
    }

    public TestInfo getInfo() {
        return this.myInfo;
    }

    public void onChanged(AbstractTestProxy test) {
        this.myChildren.resetCache();
        int magnitude = test.getMagnitude();
        this.getState().update();
        if (this.myPreviousMagnitude < magnitude || this.getState().getMagnitude() <= magnitude) {
            this.fireStateChanged();
            this.myPreviousMagnitude = this.getState().getMagnitude();
        }
    }

    public void onStatisticsChanged() {
        this.myChildren.resetCache();
        if (this.myParent != null) {
            this.myParent.onStatisticsChanged();
        }
        this.pullEvent(new StatisticsChanged(this));
        this.myNotifier.onStatisticsChanged(this);
    }

    public void addListener(TestProxyListener listener) {
        this.myNotifier.addListener(listener);
    }

    public void setStatistics(Statistics statistics) {
        if (!this.myState.isFinal()) {
            LOG.error(String.valueOf(this.myState.getMagnitude()));
        }
        this.myStatistics = statistics;
        this.onStatisticsChanged();
    }

    public Statistics getStatisticsImpl() {
        return this.myStatistics;
    }

    public boolean hasChildSuites() {
        return this.myChildren.detect(NOT_LEAF) != null;
    }

    public Statistics getStatistics() {
        return this.myState.getStatisticsFor(this);
    }

    public TestProxy[] selectChildren(Filter filter) {
        return this.myChildren.select(filter);
    }

    public void setEventsConsumer(TestEventsConsumer eventsConsumer) {
        this.myEventsConsumer = eventsConsumer;
    }

    private void pullEvent(TestEvent event) {
        if (this.myEventsConsumer != null) {
            this.myEventsConsumer.onEvent(event);
            return;
        }
        if (this.myParent != null) {
            this.myParent.pullEvent(event);
        }
    }

    public List<TestProxy> getAllTests() {
        return this.myState.getAllTestsOf(this);
    }

    public void collectAllTestsTo(ArrayList<TestProxy> allTests) {
        allTests.add(this);
        Iterator iterator = this.myChildren.iterator();
        while (iterator.hasNext()) {
            TestProxy testProxy = (TestProxy)((Object)iterator.next());
            testProxy.collectAllTestsTo(allTests);
        }
    }

    public TestProxy getCommonAncestor(TestProxy test) {
        if (test == null) {
            return this;
        }
        if (test.isAncestorOf(this)) {
            return test;
        }
        for (TestProxy parent = this; parent != null; parent = parent.getParent()) {
            if (!parent.isAncestorOf(test)) continue;
            return parent;
        }
        return null;
    }

    public boolean isAncestorOf(TestProxy test) {
        if (test == null) {
            return false;
        }
        for (TestProxy parent = test; parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    public AbstractTestProxy[] getPathFromRoot() {
        ArrayList<TestProxy> parents = new ArrayList<TestProxy>();
        TestProxy test = this;
        do {
            parents.add(test);
        } while ((test = test.getParent()) != null);
        Collections.reverse(parents);
        return parents.toArray(new TestProxy[parents.size()]);
    }

    public Long getDuration() {
        return this.getStatistics().getTime();
    }

    public boolean shouldSkipRootNodeForExport() {
        return false;
    }

    public DiffHyperlink getDiffViewerProvider() {
        if (this.myState instanceof ComparisonFailureState) {
            return ((ComparisonFailureState)this.myState).getHyperlink();
        }
        for (TestProxy proxy : this.getChildren()) {
            DiffHyperlink provider;
            if (!proxy.isDefect() || (provider = proxy.getDiffViewerProvider()) == null) continue;
            return provider;
        }
        return null;
    }
}

