/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui;

import com.intellij.CvsBundle;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FormUtils {
    private FormUtils() {
    }

    public static String getFieldValue(JTextField field, boolean check) {
        String value = field.getText().trim();
        if (check && value.isEmpty()) {
            throw new InputException(CvsBundle.message((String)"error.message.value.cannot.be.empty", (Object[])new Object[]{FormUtils.getLabelText(field)}), (JComponent)field);
        }
        return value;
    }

    public static String getFieldValue(TextFieldWithBrowseButton field, boolean check) {
        String value = field.getText().trim();
        if (check && value.isEmpty()) {
            throw new InputException(CvsBundle.message((String)"error.message.value.cannot.be.empty", (Object[])new Object[]{FormUtils.getLabelText((JComponent)field)}), (JComponent)field);
        }
        return value;
    }

    private static String getLabelText(JComponent field) {
        JLabel label = (JLabel)field.getClientProperty("labeledBy");
        String text = label.getText();
        if (text.endsWith(":")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static int getPositiveIntFieldValue(JTextField field, boolean check, boolean emptyAllowed, int max) {
        String text = field.getText().trim();
        if (text.isEmpty()) {
            if (check && !emptyAllowed) {
                throw new InputException(CvsBundle.message((String)"error.message.value.cannot.be.empty", (Object[])new Object[]{FormUtils.getLabelText(field)}), (JComponent)field);
            }
            return -1;
        }
        try {
            int intPort = Integer.parseInt(text);
            if (check && (intPort <= 0 || intPort > max)) {
                throw new InputException(CvsBundle.message((String)"error.message.invalid.value", (Object[])new Object[]{FormUtils.getLabelText(field), text}), (JComponent)field);
            }
            return intPort;
        }
        catch (NumberFormatException ex) {
            if (check) {
                throw new InputException(CvsBundle.message((String)"error.message.invalid.value", (Object[])new Object[]{FormUtils.getLabelText(field), text}), (JComponent)field);
            }
            return -1;
        }
    }
}

