/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsLog;

import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchesProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.vcs.FilePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;

public class LogOperation
extends CvsOperationOnFiles
implements BranchesProvider {
    private final List<LogInformation> myLogInformationList = new ArrayList<LogInformation>();

    public LogOperation(Collection<FilePath> files) {
        for (FilePath file : files) {
            this.addFile(file.getIOFile());
        }
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        LogCommand command = new LogCommand();
        this.addFilesToCommand(root, (AbstractCommand)command);
        command.setHeaderOnly(true);
        return command;
    }

    @Override
    public void fileInfoGenerated(Object info) {
        super.fileInfoGenerated(info);
        if (info instanceof LogInformation) {
            this.myLogInformationList.add((LogInformation)info);
        }
    }

    @Override
    public Collection<String> getAllBranches() {
        return TagsHelper.getAllBranches(this.myLogInformationList);
    }

    @Override
    public Collection<CvsRevisionNumber> getAllRevisions() {
        return null;
    }

    public List<LogInformation> getLogInformationList() {
        return this.myLogInformationList;
    }

    @Override
    protected String getOperationName() {
        return "log";
    }

    @Override
    public int getFilesToProcessCount() {
        return -1;
    }
}

