/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsAnnotate;

import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Annotation {
    private final String myRevision;
    private String myUser;
    private Date myDate;
    private static final String DATE_FORMAT_STRING = "dd-MMM-yy";
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("dd-MMM-yy", Locale.US));
    public static final String CONTENT_SEPARATOR = ": ";

    public static Annotation createOnMessage(String message) throws ParseException {
        int firstWhiteSpace = message.indexOf(" ");
        String revision = message.substring(0, firstWhiteSpace);
        String tail = message.substring(firstWhiteSpace + 1);
        int endOfDatePosition = tail.indexOf(CONTENT_SEPARATOR);
        String date = tail.substring(endOfDatePosition - DATE_FORMAT_STRING.length() - 1, endOfDatePosition - 1);
        String userWithLeftParentheses = tail.substring(0, endOfDatePosition - DATE_FORMAT_STRING.length() - 1 - 1).trim();
        String user = userWithLeftParentheses.substring(1);
        return new Annotation(revision, user, DATE_FORMAT.parse(date));
    }

    public Annotation(String revision, String user, Date date) {
        this.myRevision = revision;
        this.myUser = user;
        this.myDate = date;
    }

    public String getUserName() {
        return this.myUser;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public Date getDate() {
        return this.myDate;
    }

    public String getPresentableDateString() {
        return DateFormatUtil.formatPrettyDate((Date)this.getDate());
    }

    public static String createMessageOn(String message) {
        int index = message.indexOf(CONTENT_SEPARATOR);
        if (index < 0) {
            return "";
        }
        return message.substring(index + CONTENT_SEPARATOR.length(), message.length()).replaceAll("\r", "");
    }

    public void setUser(String user) {
        this.myUser = user;
    }

    public void setDate(Date date) {
        this.myDate = date;
    }
}

