/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.lib.cvsclient.admin.EntriesHandler;
import org.netbeans.lib.cvsclient.admin.Entry;

public class IOFilesBasedDirectoryPruner {
    private final List<File> myFiles = new ArrayList<File>();
    private final ProgressIndicator myProgressIndicator;
    private final String myCharset = CvsApplicationLevelConfiguration.getCharset();

    public IOFilesBasedDirectoryPruner(ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
    }

    public void addFile(File file) {
        this.myFiles.add(file);
    }

    public void execute() {
        for (File myFile : this.myFiles) {
            this.execute(myFile);
        }
    }

    private boolean execute(File file) {
        File[] subFiles;
        if (file.isFile()) {
            return false;
        }
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setText(CvsBundle.message((String)"progress.text.prune.empty.directories", (Object[])new Object[0]));
            this.myProgressIndicator.setText2(CvsBundle.message((String)"progress.text.processing", (Object[])new Object[]{file.getAbsolutePath()}));
        }
        if ((subFiles = file.listFiles()) == null) {
            return true;
        }
        if (!new File(file, "CVS").isDirectory()) {
            return false;
        }
        boolean canPrune = true;
        for (File subFile : subFiles) {
            if (IOFilesBasedDirectoryPruner.isAdminDirectory(subFile)) continue;
            canPrune &= this.execute(subFile);
        }
        if (!(canPrune &= !this.containsFileEntries(file))) {
            return false;
        }
        if (!FileUtil.delete((File)file)) {
            return false;
        }
        CvsUtil.removeEntryFor(file);
        return true;
    }

    private boolean containsFileEntries(File file) {
        EntriesHandler entriesHandler = new EntriesHandler(file);
        try {
            entriesHandler.read(this.myCharset);
        }
        catch (IOException e) {
            return false;
        }
        Collection entries = entriesHandler.getEntries().getEntries();
        for (Entry entry : entries) {
            if (entry.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private static boolean isAdminDirectory(File file) {
        return file.isDirectory() && file.getName().equals("CVS");
    }
}

