/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.pserver.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.ui.CvsConfigurationPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PServerSettingsPanel {
    private TextFieldWithBrowseButton myPathToPasswordFile;
    private JTextField myTimeout;
    private JPanel myPanel;
    private JLabel myConnectionTimeoutLabel;
    private JLabel myPasswordFileLabel;

    public PServerSettingsPanel(Project project) {
        this.$$$setupUI$$$();
        CvsConfigurationPanel.addBrowseHandler(project, this.myPathToPasswordFile, CvsBundle.message((String)"dialog.title.select.path.to.cvs.password.file", (Object[])new Object[0]));
        this.myConnectionTimeoutLabel.setLabelFor(this.myTimeout);
        this.myPasswordFileLabel.setLabelFor(this.myPathToPasswordFile.getTextField());
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void updateFrom(CvsApplicationLevelConfiguration config) {
        this.myPathToPasswordFile.setText(config.getPathToPassFilePresentation());
        this.myPathToPasswordFile.getTextField().selectAll();
        this.myTimeout.setText(String.valueOf(config.TIMEOUT));
        this.myTimeout.selectAll();
    }

    public void saveTo(CvsApplicationLevelConfiguration config) {
        String pathToPasswordFile = CvsApplicationLevelConfiguration.convertToIOFilePath(this.myPathToPasswordFile.getText());
        File passwordFile = new File(pathToPasswordFile);
        if (!passwordFile.exists()) {
            int result = Messages.showYesNoDialog((Component)this.myPanel, (String)CvsBundle.message((String)"message.password.file.does.not.exist", (Object[])new Object[]{pathToPasswordFile}), (String)CvsBundle.message((String)"title.password.file.does.not.exist", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 1) {
                throw new InputException((JComponent)this.myPathToPasswordFile);
            }
            try {
                passwordFile.createNewFile();
            }
            catch (IOException e) {
                throw new InputException(e.getMessage(), (JComponent)this.myPathToPasswordFile);
            }
        }
        config.setPathToPasswordFile(pathToPasswordFile);
        try {
            int timeout = Integer.parseInt(this.myTimeout.getText());
            if (timeout < 0) {
                this.throwInvalidTimeoutException();
            }
            config.TIMEOUT = timeout;
        }
        catch (NumberFormatException ex) {
            this.throwInvalidTimeoutException();
        }
    }

    private void throwInvalidTimeoutException() {
        throw new InputException(CvsBundle.message((String)"exception.message.invalid.timeout.value", (Object[])new Object[]{this.myTimeout.getText()}), (JComponent)this.myTimeout);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPasswordFileLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.pserver.password.file"));
        jLabel2.setRequestFocusEnabled(false);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPathToPasswordFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 0, null, new Dimension(250, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTimeout = jTextField = new JTextField();
        jTextField.setText("");
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(50, -1), new Dimension(50, -1)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.pserver.seconds"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConnectionTimeoutLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.configure.pserver.connection.timeout"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

