/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.openapi.util.io.FileUtil;
import java.util.List;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public class LogInformationWrapper {
    private final String myFile;
    private final List<Revision> myRevisions;
    private final List<SymbolicName> mySymbolicNames;
    private static final String CVS_REPOSITORY_FILE_POSTFIX = ",v";

    public LogInformationWrapper(String file, List<Revision> revisions, List<SymbolicName> symbolicNames) {
        this.myFile = file;
        this.myRevisions = revisions;
        this.mySymbolicNames = symbolicNames;
    }

    public String getFile() {
        return this.myFile;
    }

    public List<Revision> getRevisions() {
        return this.myRevisions;
    }

    public List<SymbolicName> getSymbolicNames() {
        return this.mySymbolicNames;
    }

    public static LogInformationWrapper wrap(String repository, String module, LogInformation log) {
        if (log.getRevisionList().isEmpty()) {
            return null;
        }
        String rcsFileName = log.getRcsFileName();
        if (FileUtil.toSystemIndependentName((String)rcsFileName).startsWith(FileUtil.toSystemIndependentName((String)repository))) {
            return LogInformationWrapper.buildWrapper(log, rcsFileName, repository.length());
        }
        int index = rcsFileName.indexOf(module);
        if (index >= 0) {
            return LogInformationWrapper.buildWrapper(log, rcsFileName, index);
        }
        return null;
    }

    private static LogInformationWrapper buildWrapper(LogInformation log, String rcsFileName, int length) {
        String relativePath = rcsFileName.substring(length);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.endsWith(CVS_REPOSITORY_FILE_POSTFIX)) {
            relativePath = relativePath.substring(0, relativePath.length() - CVS_REPOSITORY_FILE_POSTFIX.length());
        }
        return new LogInformationWrapper(relativePath, log.getRevisionList(), log.getAllSymbolicNames());
    }
}

