/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.AddFileOrDirectoryAction;
import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.ui.Options;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class IgnoreFileAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.actions.IgnoreFileAction");
    private final CvsActionVisibility myVisibility = new CvsActionVisibility();

    public IgnoreFileAction() {
        this.myVisibility.canBePerformedOnSeveralFiles();
        this.myVisibility.addCondition(ActionOnSelectedElement.FILES_ARENT_UNDER_CVS);
        this.myVisibility.addCondition(ActionOnSelectedElement.FILES_ARE_NOT_IGNORED);
    }

    public void update(AnActionEvent e) {
        this.myVisibility.applyToEvent(e);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] selectedFiles;
        MultiMap parentToSelectedChildren = MultiMap.createSmart();
        CvsContext context = CvsContextWrapper.createCachedInstance(e);
        for (VirtualFile selectedFile : selectedFiles = context.getSelectedFiles()) {
            VirtualFile parent = selectedFile.getParent();
            parentToSelectedChildren.putValue((Object)parent, (Object)selectedFile);
            try {
                CvsUtil.ignoreFile(selectedFile);
            }
            catch (IOException e1) {
                String message = CvsBundle.message((String)"message.error.ignore.files", (Object[])new Object[]{selectedFile.getPresentableUrl(), e1.getLocalizedMessage()});
                VcsBalloonProblemNotifier.showOverChangesView((Project)context.getProject(), (String)message, (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            }
        }
        IgnoreFileAction.refreshFilesAndStatuses(context, (MultiMap<VirtualFile, VirtualFile>)parentToSelectedChildren);
    }

    private static void refreshPanel(CvsContext context) {
        Refreshable refreshablePanel = context.getRefreshableDialog();
        if (refreshablePanel != null) {
            refreshablePanel.restoreState();
            refreshablePanel.refresh();
        }
    }

    private static void refreshFilesAndStatuses(final CvsContext context, final MultiMap<VirtualFile, VirtualFile> parentToSelectedChildren) {
        Refreshable refreshablePanel = context.getRefreshableDialog();
        if (refreshablePanel != null) {
            refreshablePanel.saveState();
        }
        final int[] refreshedParents = new int[]{0};
        final ArrayList createdCvsIgnoreFiles = new ArrayList();
        for (final VirtualFile parent : parentToSelectedChildren.keySet()) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        VirtualFile cvsIgnoreFile = CvsVfsUtil.refreshAndfFindChild(parent, ".cvsignore");
                        if (cvsIgnoreFile == null) {
                            String path = parent.getPath() + "/" + ".cvsignore";
                            LOG.error(String.valueOf(CvsVfsUtil.findFileByPath(path)) + " " + parent.getPath() + " " + new File(VfsUtil.virtualToIoFile((VirtualFile)parent), ".cvsignore").isFile());
                            return;
                        }
                        if (!(CvsUtil.fileIsUnderCvs(cvsIgnoreFile) || ChangeListManager.getInstance((Project)context.getProject()).isIgnoredFile(cvsIgnoreFile) || CvsEntriesManager.getInstance().fileIsIgnored(cvsIgnoreFile))) {
                            createdCvsIgnoreFiles.add(cvsIgnoreFile);
                        }
                        Collection filesToUpdateStatus = parentToSelectedChildren.get((Object)parent);
                        for (VirtualFile file : filesToUpdateStatus) {
                            FileStatusManager.getInstance((Project)context.getProject()).fileStatusChanged(file);
                            VcsDirtyScopeManager.getInstance((Project)context.getProject()).fileDirty(file);
                        }
                    }
                    finally {
                        refreshedParents[0] = refreshedParents[0] + 1;
                        if (refreshedParents[0] == parentToSelectedChildren.size()) {
                            if (createdCvsIgnoreFiles.isEmpty()) {
                                IgnoreFileAction.refreshPanel(context);
                            } else {
                                this.addCvsIgnoreFilesToCvsAndRefreshPanel();
                            }
                        }
                    }
                }

                private void addCvsIgnoreFilesToCvsAndRefreshPanel() {
                    this.createAddFilesAction().actionPerformed(IgnoreFileAction.createContext(createdCvsIgnoreFiles, context));
                }

                private AddFileOrDirectoryAction createAddFilesAction() {
                    return new AddFileOrDirectoryAction(CvsBundle.message((String)"adding.cvsignore.files.to.cvs.action.name", (Object[])new Object[0]), Options.ON_FILE_ADDING){

                        @Override
                        protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
                            IgnoreFileAction.refreshPanel(context);
                        }
                    };
                }
            };
            parent.refresh(true, true, runnable);
        }
    }

    private static CvsContextAdapter createContext(final Collection<VirtualFile> createdCvsIgnoreFiles, final CvsContext context) {
        return new CvsContextAdapter(){

            @Override
            public VirtualFile[] getSelectedFiles() {
                return VfsUtil.toVirtualFileArray((Collection)createdCvsIgnoreFiles);
            }

            @Override
            public Refreshable getRefreshableDialog() {
                return context.getRefreshableDialog();
            }

            @Override
            public Project getProject() {
                return context.getProject();
            }
        };
    }
}

