/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import org.picocontainer.PicoContainer;

public abstract class AbstractExtensionPointBean
implements PluginAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.extensions.AbstractExtensionPointBean");
    protected PluginDescriptor myPluginDescriptor;

    @Override
    public final void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    public final <T> Class<T> findClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.getLoaderForClass());
    }

    public final <T> Class<T> findClassNoExceptions(String className) {
        try {
            return this.findClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Problem loading class " + className + " from plugin " + this.myPluginDescriptor.getPluginId().getIdString(), (Throwable)e);
            return null;
        }
    }

    public ClassLoader getLoaderForClass() {
        return this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
    }

    public final <T> T instantiate(String className, PicoContainer container) throws ClassNotFoundException {
        return AbstractExtensionPointBean.instantiate(this.findClass(className), container);
    }

    public static <T> T instantiate(Class<T> aClass, PicoContainer container) {
        return AbstractExtensionPointBean.instantiate(aClass, container, false);
    }

    public static <T> T instantiate(Class<T> aClass, PicoContainer container, boolean allowNonPublicClasses) {
        return (T)new ConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass, null, allowNonPublicClasses).getComponentInstance(container);
    }
}

