/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact;

import org.apache.maven.mercury.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArtifactScopeEnum {
    compile(1),
    test(2),
    runtime(3),
    provided(4),
    system(5),
    none(-1);

    public static final ArtifactScopeEnum DEFAULT_SCOPE;
    private int id;
    private static final ArtifactScopeEnum[][][] _compliancySets;

    private ArtifactScopeEnum(int id) {
        this.id = id;
    }

    int getId() {
        return this.id;
    }

    public static final ArtifactScopeEnum checkScope(ArtifactScopeEnum scope) {
        return scope == null ? DEFAULT_SCOPE : scope;
    }

    public String getScope() {
        if (this.id == 1) {
            return Artifact.SCOPE_COMPILE;
        }
        if (this.id == 2) {
            return Artifact.SCOPE_TEST;
        }
        if (this.id == 3) {
            return Artifact.SCOPE_RUNTIME;
        }
        if (this.id == 4) {
            return Artifact.SCOPE_PROVIDED;
        }
        if (this.id == 5) {
            return Artifact.SCOPE_SYSTEM;
        }
        return Artifact.SCOPE_SYSTEM;
    }

    public boolean encloses(ArtifactScopeEnum scope) {
        ArtifactScopeEnum s = ArtifactScopeEnum.checkScope(scope);
        if (this.id == ArtifactScopeEnum.system.id) {
            return scope.id == ArtifactScopeEnum.system.id;
        }
        for (ArtifactScopeEnum[][] set : _compliancySets) {
            if (this.id != set[0][0].id) continue;
            for (ArtifactScopeEnum ase : set[1]) {
                if (s.id != ase.id) continue;
                return true;
            }
            break;
        }
        return false;
    }

    static {
        DEFAULT_SCOPE = compile;
        _compliancySets = new ArtifactScopeEnum[][][]{{{compile}, {compile, provided, system}}, {{test}, {compile, test, provided, system}}, {{runtime}, {compile, runtime, system}}, {{provided}, {compile, test, provided}}};
    }
}

