/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class SimpleCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, BaseCoverageAnnotator.FileCoverageInfo> myFileCoverageInfos = new HashMap();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myTestDirCoverageInfos = new HashMap();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myDirCoverageInfos = new HashMap();

    public SimpleCoverageAnnotator(Project project) {
        super(project);
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myFileCoverageInfos.clear();
        this.myTestDirCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
    }

    protected BaseCoverageAnnotator.DirCoverageInfo getDirCoverageInfo(PsiDirectory directory, CoverageSuitesBundle currentSuite) {
        VirtualFile dir = directory.getVirtualFile();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex();
        boolean isInTestContent = projectFileIndex.isInTestSourceContent(dir);
        if (!currentSuite.isTrackTestFolders() && isInTestContent) {
            return null;
        }
        String path = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        return isInTestContent ? this.myTestDirCoverageInfos.get(path) : this.myDirCoverageInfos.get(path);
    }

    @Override
    public String getDirCoverageInformationString(PsiDirectory directory, CoverageSuitesBundle currentSuite, CoverageDataManager manager) {
        BaseCoverageAnnotator.DirCoverageInfo coverageInfo = this.getDirCoverageInfo(directory, currentSuite);
        if (coverageInfo == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? "covered" : null;
        }
        String filesCoverageInfo = this.getFilesCoverageInformationString(coverageInfo);
        if (filesCoverageInfo != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(filesCoverageInfo);
            String linesCoverageInfo = this.getLinesCoverageInformationString(coverageInfo);
            if (linesCoverageInfo != null) {
                builder.append(", ").append(linesCoverageInfo);
            }
            return builder.toString();
        }
        return null;
    }

    @Deprecated
    public static String getFilePath(String filePath) {
        return SimpleCoverageAnnotator.normalizeFilePath(filePath);
    }

    private static String normalizeFilePath(String filePath) {
        if (SystemInfo.isWindows) {
            filePath = filePath.toLowerCase();
        }
        return FileUtil.toSystemIndependentName((String)filePath);
    }

    @Override
    public String getFileCoverageInformationString(PsiFile psiFile, CoverageSuitesBundle currentSuite, CoverageDataManager manager) {
        VirtualFile file = psiFile.getVirtualFile();
        assert (file != null);
        String path = SimpleCoverageAnnotator.normalizeFilePath(file.getPath());
        BaseCoverageAnnotator.FileCoverageInfo coverageInfo = this.myFileCoverageInfos.get(path);
        if (coverageInfo == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? "covered" : null;
        }
        return this.getLinesCoverageInformationString(coverageInfo);
    }

    protected BaseCoverageAnnotator.FileCoverageInfo collectBaseFileCoverage(VirtualFile file, Annotator annotator, ProjectData projectData, Map<String, String> normalizedFiles2Files) {
        String filePath = SimpleCoverageAnnotator.normalizeFilePath(file.getPath());
        ClassData classData = SimpleCoverageAnnotator.getClassData(filePath, projectData, normalizedFiles2Files);
        BaseCoverageAnnotator.FileCoverageInfo info = classData != null ? SimpleCoverageAnnotator.fileInfoForCoveredFile(classData) : this.fillInfoForUncoveredFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (info != null) {
            annotator.annotateFile(filePath, info);
        }
        return info;
    }

    private static ClassData getClassData(String filePath, ProjectData data, Map<String, String> normalizedFiles2Files) {
        String originalFileName = normalizedFiles2Files.get(filePath);
        if (originalFileName == null) {
            return null;
        }
        return data.getClassData(originalFileName);
    }

    protected BaseCoverageAnnotator.DirCoverageInfo collectFolderCoverage(final VirtualFile dir, CoverageDataManager dataManager, Annotator annotator, ProjectData projectInfo, boolean trackTestFolders, ProjectFileIndex index, CoverageEngine coverageEngine, Set<VirtualFile> visitedDirs, Map<String, String> normalizedFiles2Files) {
        if (!index.isInContent(dir)) {
            return null;
        }
        if (visitedDirs.contains(dir)) {
            return null;
        }
        visitedDirs.add(dir);
        boolean isInTestSrcContent = index.isInTestSourceContent(dir);
        if (!trackTestFolders && isInTestSrcContent) {
            return null;
        }
        VirtualFile[] children = dataManager.doInReadActionIfProjectOpen(new Computable<VirtualFile[]>(){

            public VirtualFile[] compute() {
                return dir.getChildren();
            }
        });
        if (children == null) {
            return null;
        }
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = new BaseCoverageAnnotator.DirCoverageInfo();
        for (VirtualFile fileOrDir : children) {
            BaseCoverageAnnotator.FileCoverageInfo fileInfo;
            if (fileOrDir.isDirectory()) {
                BaseCoverageAnnotator.DirCoverageInfo childCoverageInfo = this.collectFolderCoverage(fileOrDir, dataManager, annotator, projectInfo, trackTestFolders, index, coverageEngine, visitedDirs, normalizedFiles2Files);
                if (childCoverageInfo == null) continue;
                dirCoverageInfo.totalFilesCount += childCoverageInfo.totalFilesCount;
                dirCoverageInfo.coveredFilesCount += childCoverageInfo.coveredFilesCount;
                dirCoverageInfo.totalLineCount += childCoverageInfo.totalLineCount;
                dirCoverageInfo.coveredLineCount += childCoverageInfo.coveredLineCount;
                continue;
            }
            if (!coverageEngine.coverageProjectViewStatisticsApplicableTo(fileOrDir) || (fileInfo = this.collectBaseFileCoverage(fileOrDir, annotator, projectInfo, normalizedFiles2Files)) == null) continue;
            dirCoverageInfo.totalLineCount += fileInfo.totalLineCount;
            ++dirCoverageInfo.totalFilesCount;
            if (fileInfo.coveredLineCount <= 0) continue;
            ++dirCoverageInfo.coveredFilesCount;
            dirCoverageInfo.coveredLineCount += fileInfo.coveredLineCount;
        }
        if (dirCoverageInfo.totalFilesCount == 0) {
            return null;
        }
        String dirPath = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        if (isInTestSrcContent) {
            annotator.annotateTestDirectory(dirPath, dirCoverageInfo);
        } else {
            annotator.annotateSourceDirectory(dirPath, dirCoverageInfo);
        }
        return dirCoverageInfo;
    }

    public void annotate(VirtualFile contentRoot, CoverageSuitesBundle suite, CoverageDataManager dataManager, ProjectData data, Project project, Annotator annotator) {
        if (!contentRoot.isValid()) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Set files = data.getClasses().keySet();
        java.util.HashMap normalizedFiles2Files = ContainerUtil.newHashMap();
        for (String file : files) {
            normalizedFiles2Files.put(SimpleCoverageAnnotator.normalizeFilePath(file), file);
        }
        this.collectFolderCoverage(contentRoot, dataManager, annotator, data, suite.isTrackTestFolders(), index, suite.getCoverageEngine(), ContainerUtil.newHashSet(), Collections.unmodifiableMap(normalizedFiles2Files));
    }

    @Override
    protected Runnable createRenewRequest(final CoverageSuitesBundle suite, final CoverageDataManager dataManager) {
        final ProjectData data = suite.getCoverageData();
        if (data == null) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                Project project = SimpleCoverageAnnotator.this.getProject();
                final ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
                VirtualFile[] modulesContentRoots = dataManager.doInReadActionIfProjectOpen(new Computable<VirtualFile[]>(){

                    public VirtualFile[] compute() {
                        return rootManager.getContentRoots();
                    }
                });
                if (modulesContentRoots == null) {
                    return;
                }
                for (VirtualFile root : modulesContentRoots) {
                    SimpleCoverageAnnotator.this.annotate(root, suite, dataManager, data, project, new Annotator(){

                        @Override
                        public void annotateSourceDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                            SimpleCoverageAnnotator.this.myDirCoverageInfos.put(dirPath, info);
                        }

                        @Override
                        public void annotateTestDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                            SimpleCoverageAnnotator.this.myTestDirCoverageInfos.put(dirPath, info);
                        }

                        @Override
                        public void annotateFile(String filePath, BaseCoverageAnnotator.FileCoverageInfo info) {
                            SimpleCoverageAnnotator.this.myFileCoverageInfos.put(filePath, info);
                        }
                    });
                }
                dataManager.triggerPresentationUpdate();
            }
        };
    }

    protected String getLinesCoverageInformationString(BaseCoverageAnnotator.FileCoverageInfo info) {
        return SimpleCoverageAnnotator.calcCoveragePercentage(info) + "% lines covered";
    }

    protected static int calcCoveragePercentage(BaseCoverageAnnotator.FileCoverageInfo info) {
        return SimpleCoverageAnnotator.calcPercent(info.coveredLineCount, info.totalLineCount);
    }

    private static int calcPercent(int covered, int total) {
        return total != 0 ? (int)((double)covered / (double)total * 100.0) : 100;
    }

    protected String getFilesCoverageInformationString(BaseCoverageAnnotator.DirCoverageInfo info) {
        return SimpleCoverageAnnotator.calcPercent(info.coveredFilesCount, info.totalFilesCount) + "% files";
    }

    private static BaseCoverageAnnotator.FileCoverageInfo fileInfoForCoveredFile(ClassData classData) {
        Object[] lines = classData.getLines();
        int count = lines.length - 1;
        if (count == 0) {
            return null;
        }
        BaseCoverageAnnotator.FileCoverageInfo info = new BaseCoverageAnnotator.FileCoverageInfo();
        int srcLinesCount = 0;
        int coveredLinesCount = 0;
        for (int i = 1; i <= count; ++i) {
            LineData lineData = classData.getLineData(i);
            if (lineData == null) continue;
            int status = lineData.getStatus();
            if (status != 0) {
                ++coveredLinesCount;
            }
            ++srcLinesCount;
        }
        info.totalLineCount = srcLinesCount;
        info.coveredLineCount = coveredLinesCount;
        return info;
    }

    protected BaseCoverageAnnotator.FileCoverageInfo fillInfoForUncoveredFile(File file) {
        return null;
    }

    private static interface Annotator {
        public void annotateSourceDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateTestDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateFile(String var1, BaseCoverageAnnotator.FileCoverageInfo var2);
    }
}

