/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.IOException;

public abstract class JavaCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaCoverageRunner.class.getName()));
    private static final String COVERAGE_AGENT_PATH = "coverage.lib.path";

    public boolean isJdk7Compatible() {
        return true;
    }

    @Override
    public boolean acceptsCoverageEngine(CoverageEngine engine) {
        return engine instanceof JavaCoverageEngine;
    }

    public abstract void appendCoverageArgument(String var1, String[] var2, SimpleJavaParameters var3, boolean var4, boolean var5);

    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, SimpleJavaParameters parameters, boolean collectLineInfo, boolean isSampling, String sourceMapPath) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, parameters, collectLineInfo, isSampling);
    }

    protected static String handleSpacesInPath(String agentPath) {
        String userDefined = System.getProperty(COVERAGE_AGENT_PATH);
        agentPath = userDefined != null && new File(userDefined).exists() ? userDefined : new File(agentPath).getParent();
        if (!SystemInfo.isWindows && agentPath.contains(" ")) {
            File dir = new File(PathManager.getSystemPath(), "coverageJars");
            if (dir.getAbsolutePath().contains(" ")) {
                try {
                    dir = FileUtil.createTempDirectory((String)"coverage", (String)"jars");
                    if (dir.getAbsolutePath().contains(" ")) {
                        LOG.info("Coverage agent not used since the agent path contains spaces: " + agentPath + "\n" + "One can move the agent libraries to a directory with no spaces in path and specify its path in idea.properties as " + COVERAGE_AGENT_PATH + "=<path>");
                        return agentPath;
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    return agentPath;
                }
            }
            try {
                LOG.info("Coverage jars were copied to " + dir.getPath());
                FileUtil.copyDir((File)new File(agentPath), (File)dir);
                return dir.getPath();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return agentPath;
    }

    protected static void write2file(File tempFile, String arg) throws IOException {
        FileUtil.writeToFile((File)tempFile, (byte[])(arg + "\n").getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
    }

    protected static File createTempFile() throws IOException {
        String userDefined;
        File tempFile = FileUtil.createTempFile((String)"coverage", (String)"args");
        if (!SystemInfo.isWindows && tempFile.getAbsolutePath().contains(" ") && (tempFile = FileUtil.createTempFile((File)new File(PathManager.getSystemPath(), "coverage"), (String)"coverage", (String)"args", (boolean)true)).getAbsolutePath().contains(" ") && (userDefined = System.getProperty(COVERAGE_AGENT_PATH)) != null && new File(userDefined).isDirectory()) {
            tempFile = FileUtil.createTempFile((File)new File(userDefined), (String)"coverage", (String)"args", (boolean)true);
        }
        return tempFile;
    }
}

