/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.info.CoberturaLoaderUtil;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;

public class CoberturaCoverageRunner
extends JavaCoverageRunner {
    @Override
    public ProjectData loadCoverageData(File sessionDataFile, CoverageSuite coverageSuite) {
        return CoberturaLoaderUtil.load(sessionDataFile);
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, SimpleJavaParameters javaParameters, boolean collectLineInfo, boolean isSampling) {
        StringBuffer argument = new StringBuffer("-javaagent:");
        argument.append(PathManager.getLibPath()).append(File.separator);
        argument.append("cobertura.jar=");
        if (patterns != null && patterns.length > 0) {
            for (String coveragePattern : patterns) {
                if (!(coveragePattern = coveragePattern.replace("$", "\\$").replace(".", "\\.").replaceAll("\\*", ".*")).endsWith(".*")) {
                    coveragePattern = coveragePattern + "(\\$.*)*";
                }
                argument.append("--includeClasses ").append(coveragePattern).append(" ");
            }
        }
        if (SystemInfo.isWindows) {
            argument.append("--datafile ").append("\\\"").append(sessionDataFilePath).append("\\\"");
        } else {
            argument.append("--datafile ").append(sessionDataFilePath);
        }
        javaParameters.getVMParametersList().add(argument.toString());
        javaParameters.getVMParametersList().defineProperty("net.sourceforge.cobertura.datafile", sessionDataFilePath);
        javaParameters.getClassPath().add(PathManager.getLibPath() + File.separator + "cobertura.jar");
    }

    @Override
    public String getPresentableName() {
        return "Cobertura";
    }

    @Override
    public String getId() {
        return "cobertura";
    }

    @Override
    public String getDataFileExtension() {
        return "ser";
    }
}

