/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png.chunks;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.ZLibUtils;
import org.apache.sanselan.formats.png.PngText;
import org.apache.sanselan.formats.png.chunks.PNGTextChunk;

public class PNGChunkiTXt
extends PNGTextChunk {
    public final String keyword;
    public final String text;
    public final String languageTag;
    public final String translatedKeyword;

    public PNGChunkiTXt(int length, int chunkType, int crc, byte[] bytes) throws ImageReadException, IOException {
        super(length, chunkType, crc, bytes);
        byte compressionFlag;
        int terminator = this.findNull(bytes);
        if (terminator < 0) {
            throw new ImageReadException("PNG iTXt chunk keyword is not terminated.");
        }
        this.keyword = new String(bytes, 0, terminator, "ISO-8859-1");
        int index = terminator + 1;
        if ((compressionFlag = bytes[index++]) != 0 && compressionFlag != 1) {
            throw new ImageReadException("PNG iTXt chunk has invalid compression flag: " + compressionFlag);
        }
        boolean compressed = compressionFlag == 1;
        byte compressionMethod = bytes[index++];
        if (compressed) {
            if (compressionMethod != 0) {
                throw new ImageReadException("PNG iTXt chunk has unexpected compression method: " + compressionMethod);
            }
            if (compressionMethod != 0) {
                throw new ImageReadException("PNG iTXt chunk has unexpected compression method: " + compressionMethod);
            }
        }
        if ((terminator = this.findNull(bytes, index)) < 0) {
            throw new ImageReadException("PNG iTXt chunk language tag is not terminated.");
        }
        this.languageTag = new String(bytes, index, terminator - index, "ISO-8859-1");
        index = terminator + 1;
        if ((terminator = this.findNull(bytes, index)) < 0) {
            throw new ImageReadException("PNG iTXt chunk translated keyword is not terminated.");
        }
        this.translatedKeyword = new String(bytes, index, terminator - index, "utf-8");
        index = terminator + 1;
        if (compressed) {
            int compressedTextLength = bytes.length - index;
            byte[] compressedText = new byte[compressedTextLength];
            System.arraycopy(bytes, index, compressedText, 0, compressedTextLength);
            this.text = new String(new ZLibUtils().inflate(compressedText), "utf-8");
        } else {
            this.text = new String(bytes, index, bytes.length - index, "utf-8");
        }
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public PngText getContents() {
        return new PngText.iTXt(this.keyword, this.text, this.languageTag, this.translatedKeyword);
    }
}

