/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.decoder;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;

public class JpegInputStream {
    private final InputStream is;
    private int cnt = 0;
    private int b;

    public JpegInputStream(InputStream is) {
        this.is = is;
    }

    public int nextBit() throws IOException, ImageReadException {
        if (this.cnt == 0) {
            this.b = this.is.read();
            if (this.b < 0) {
                throw new ImageReadException("Premature End of File");
            }
            this.cnt = 8;
            if (this.b == 255) {
                int b2 = this.is.read();
                if (b2 < 0) {
                    throw new ImageReadException("Premature End of File");
                }
                if (b2 != 0) {
                    if (b2 == 220) {
                        throw new ImageReadException("DNL not yet supported");
                    }
                    throw new ImageReadException("Invalid marker found in entropy data");
                }
            }
        }
        int bit = this.b >> 7 & 1;
        --this.cnt;
        this.b <<= 1;
        return bit;
    }
}

