/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.template;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionData;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovyTemplateContextType
extends TemplateContextType {
    protected GroovyTemplateContextType(String id, String presentableName, Class<? extends TemplateContextType> baseContextType) {
        super(id, presentableName, baseContextType);
    }

    public boolean isInContext(PsiFile file, int offset) {
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)GroovyLanguage.INSTANCE)) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace) {
                return false;
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected abstract boolean isInContext(PsiElement var1);

    private static boolean isAfterExpression(PsiElement element) {
        PsiElement prevExpr;
        ProcessingContext context = new ProcessingContext();
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(GrExpression.class).save("prevExpr")))).accepts((Object)element, context) && (prevExpr = (PsiElement)context.get((Object)"prevExpr")).getTextRange().getEndOffset() <= element.getTextRange().getStartOffset();
    }

    public static class Declaration
    extends GroovyTemplateContextType {
        public Declaration() {
            super("GROOVY_DECLARATION", "Declaration", Generic.class);
        }

        @Override
        protected boolean isInContext(PsiElement element) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, GrCodeBlock.class, (boolean)false, (Class[])new Class[]{GrTypeDefinition.class}) != null) {
                return false;
            }
            if (element instanceof PsiComment) {
                return false;
            }
            return GroovyCompletionData.suggestClassInterfaceEnum(element) || GroovyCompletionData.suggestFinalDef(element);
        }
    }

    public static class Expression
    extends GroovyTemplateContextType {
        public Expression() {
            super("GROOVY_EXPRESSION", "Expression", Generic.class);
        }

        @Override
        protected boolean isInContext(PsiElement element) {
            return Expression.isExpressionContext(element);
        }

        private static boolean isExpressionContext(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof GrReferenceExpression)) {
                return false;
            }
            if (((GrReferenceExpression)parent).isQualified()) {
                return false;
            }
            if (parent.getParent() instanceof GrCall) {
                return false;
            }
            return !GroovyTemplateContextType.isAfterExpression(element);
        }
    }

    public static class Statement
    extends GroovyTemplateContextType {
        public Statement() {
            super("GROOVY_STATEMENT", "Statement", Generic.class);
        }

        @Override
        protected boolean isInContext(PsiElement element) {
            PsiElement stmt = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new Condition<PsiElement>(){

                public boolean value(PsiElement element11) {
                    return PsiUtil.isExpressionStatement(element11);
                }
            });
            return !GroovyTemplateContextType.isAfterExpression(element) && stmt != null && stmt.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
        }
    }

    public static class Generic
    extends GroovyTemplateContextType {
        public Generic() {
            super("GROOVY", "Groovy", EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(PsiElement element) {
            return true;
        }
    }
}

