/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public abstract class GroovyScriptRunner {
    public abstract boolean isValidModule(Module var1);

    public abstract boolean ensureRunnerConfigured(Module var1, RunProfile var2, Executor var3, Project var4) throws ExecutionException;

    public abstract void configureCommandLine(JavaParameters var1, Module var2, boolean var3, VirtualFile var4, GroovyScriptRunConfiguration var5) throws CantRunException;

    public boolean shouldRefreshAfterFinish() {
        return false;
    }

    protected static String getConfPath(String groovyHomePath) {
        String confpath = FileUtil.toSystemDependentName((String)(groovyHomePath + "/conf/groovy-starter.conf"));
        if (new File(confpath).exists()) {
            return confpath;
        }
        return GroovyScriptRunner.getPathInConf("groovy-starter.conf");
    }

    public static String getPathInConf(String fileName) {
        try {
            String jarPath = PathUtil.getJarPathForClass(GroovyLanguage.class);
            if (new File(jarPath).isFile()) {
                return new File(jarPath, "../" + fileName).getCanonicalPath();
            }
            return new File(jarPath, "conf/" + fileName).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setGroovyHome(JavaParameters params, String groovyHome) {
        params.getVMParametersList().add("-Dgroovy.home=" + groovyHome);
        if (groovyHome.contains("grails")) {
            params.getVMParametersList().add("-Dgrails.home=" + groovyHome);
        }
        if (groovyHome.contains("griffon")) {
            params.getVMParametersList().add("-Dgriffon.home=" + groovyHome);
        }
    }

    protected static void setToolsJar(JavaParameters params) {
        String toolsPath;
        Sdk jdk = params.getJdk();
        if (jdk != null && jdk.getSdkType() instanceof JavaSdkType && (toolsPath = ((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk)) != null) {
            params.getVMParametersList().add("-Dtools.jar=" + toolsPath);
        }
    }

    protected static VirtualFile findGroovyJar(Module module) {
        VirtualFile[] files;
        for (VirtualFile root : files = OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
            if (!GroovyConfigUtils.GROOVY_JAR_PATTERN.matcher(root.getName()).matches() && !GroovyConfigUtils.matchesGroovyAll(root.getName())) continue;
            return root;
        }
        for (VirtualFile file : files) {
            if (!file.getName().contains("groovy") || !"jar".equals(file.getExtension())) continue;
            return file;
        }
        return null;
    }

    protected static void addClasspathFromRootModel(Module module, boolean isTests, JavaParameters params, boolean allowDuplication) throws CantRunException {
        PathsList nonCore = new PathsList();
        GroovyScriptRunner.getClassPathFromRootModel(module, isTests, params, allowDuplication, nonCore);
        String cp = nonCore.getPathsString();
        if (!StringUtil.isEmptyOrSpaces((String)cp)) {
            params.getProgramParametersList().add("--classpath");
            params.getProgramParametersList().add(cp);
        }
    }

    public static PathsList getClassPathFromRootModel(Module module, boolean isTests, JavaParameters params, boolean allowDuplication, PathsList pathList) throws CantRunException {
        if (module == null) {
            return null;
        }
        pathList.add(".");
        JavaParameters tmp = new JavaParameters();
        tmp.configureByModule(module, isTests ? 6 : 2);
        if (tmp.getClassPath().getVirtualFiles().isEmpty()) {
            return null;
        }
        HashSet core = new HashSet(params.getClassPath().getVirtualFiles());
        for (VirtualFile virtualFile : tmp.getClassPath().getVirtualFiles()) {
            if (!allowDuplication && core.contains(virtualFile)) continue;
            pathList.add(virtualFile);
        }
        return pathList;
    }
}

