/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrExpressionWrapper
implements IntroduceParameterData.ExpressionWrapper {
    private final GrExpression myExpression;
    private final RangeMarker myMarker;
    private final PsiFile myFile;

    public GrExpressionWrapper(GrExpression expression) {
        assert (expression.isValid());
        this.myExpression = expression;
        this.myFile = expression.getContainingFile();
        if (this.myFile.isPhysical()) {
            Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(this.myFile);
            assert (document != null);
            this.myMarker = document.createRangeMarker(this.myExpression.getTextRange());
        } else {
            this.myMarker = null;
        }
    }

    public String getText() {
        return this.myExpression.getText();
    }

    public PsiType getType() {
        return this.myExpression.getType();
    }

    public GrExpression getExpression() {
        PsiElement at;
        if (this.myExpression.isValid()) {
            return this.myExpression;
        }
        if (this.myMarker != null && this.myMarker.isValid() && (at = this.myFile.findElementAt(this.myMarker.getStartOffset())) != null) {
            return GroovyPsiElementFactory.getInstance(this.myFile.getProject()).createExpressionFromText(this.myExpression.getText(), at);
        }
        return GroovyPsiElementFactory.getInstance(this.myFile.getProject()).createExpressionFromText(this.myExpression.getText(), null);
    }
}

