/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.constant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantSettings;

public class GrIntroduceConstantProcessor {
    private final GrIntroduceContext context;
    private final GrIntroduceConstantSettings settings;

    public GrIntroduceConstantProcessor(GrIntroduceContext context, GrIntroduceConstantSettings settings) {
        this.context = context;
        this.settings = settings;
    }

    public GrField run() {
        PsiClass targetClass = this.settings.getTargetClass();
        if (targetClass == null) {
            return null;
        }
        if (this.checkErrors(targetClass)) {
            return null;
        }
        GrVariableDeclaration declaration = this.addDeclaration(targetClass);
        GrField field = (GrField)declaration.getVariables()[0];
        GrVariable localVar = GrIntroduceHandlerBase.resolveLocalVar(this.context);
        if (localVar != null) {
            assert (localVar.getInitializerGroovy() != null) : "initializer should exist: " + localVar.getText();
            GrIntroduceHandlerBase.deleteLocalVar(localVar);
            if (this.settings.replaceAllOccurrences()) {
                this.processOccurrences(field);
            } else {
                this.replaceOccurrence(field, localVar.getInitializerGroovy(), this.isEscalateVisibility());
            }
        } else if (this.context.getStringPart() != null) {
            GrExpression ref = this.context.getStringPart().replaceLiteralWithConcatenation(field.getName());
            PsiElement element = this.replaceOccurrence(field, ref, this.isEscalateVisibility());
            this.updateCaretPosition(element);
        } else if (this.context.getExpression() != null) {
            if (this.settings.replaceAllOccurrences()) {
                this.processOccurrences(field);
            } else {
                this.replaceOccurrence(field, this.context.getExpression(), this.isEscalateVisibility());
            }
        }
        return field;
    }

    private void processOccurrences(GrField field) {
        PsiElement[] occurrences = this.context.getOccurrences();
        GroovyRefactoringUtil.sortOccurrences(occurrences);
        for (PsiElement occurrence : occurrences) {
            this.replaceOccurrence(field, occurrence, this.isEscalateVisibility());
        }
    }

    private void updateCaretPosition(PsiElement element) {
        this.context.getEditor().getCaretModel().moveToOffset(element.getTextRange().getEndOffset());
        this.context.getEditor().getSelectionModel().removeSelection();
    }

    protected GrVariableDeclaration addDeclaration(PsiClass targetClass) {
        GrVariableDeclaration added;
        GrVariableDeclaration declaration = this.createField(targetClass);
        if (targetClass instanceof GrEnumTypeDefinition) {
            GrEnumConstantList enumConstants = ((GrEnumTypeDefinition)targetClass).getEnumConstantList();
            added = (GrVariableDeclaration)targetClass.addAfter((PsiElement)declaration, (PsiElement)enumConstants);
        } else {
            added = (GrVariableDeclaration)targetClass.add((PsiElement)declaration);
        }
        JavaCodeStyleManager.getInstance((Project)added.getProject()).shortenClassReferences((PsiElement)added);
        return added;
    }

    protected boolean checkErrors(PsiClass targetClass) {
        String fieldName = this.settings.getName();
        String errorString = this.check(targetClass, fieldName);
        if (errorString != null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)errorString);
            CommonRefactoringUtil.showErrorMessage((String)"Introduce Constant", (String)message, (String)"refactoring.introduceConstant", (Project)this.context.getProject());
            return true;
        }
        PsiField oldField = targetClass.findFieldByName(fieldName, true);
        if (oldField != null) {
            String message = RefactoringBundle.message((String)"field.exists", (Object[])new Object[]{fieldName, oldField.getContainingClass().getQualifiedName()});
            int answer = Messages.showYesNoDialog((Project)this.context.getProject(), (String)message, (String)"Introduce Constant", (Icon)Messages.getWarningIcon());
            if (answer != 0) {
                return true;
            }
        }
        return false;
    }

    private String check(PsiClass targetClass, String fieldName) {
        if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(targetClass.getLanguage())) {
            return GroovyRefactoringBundle.message("class.language.is.not.groovy", new Object[0]);
        }
        if (fieldName == null || fieldName.isEmpty()) {
            return RefactoringBundle.message((String)"no.field.name.specified");
        }
        if (!PsiNameHelper.getInstance((Project)this.context.getProject()).isIdentifier(fieldName)) {
            return RefactoringMessageUtil.getIncorrectIdentifierMessage((String)fieldName);
        }
        if (targetClass instanceof GroovyScriptClass) {
            return GroovyRefactoringBundle.message("target.class.must.not.be.script", new Object[0]);
        }
        return null;
    }

    private PsiElement replaceOccurrence(GrField field, PsiElement occurrence, boolean escalateVisibility) {
        PsiElement replaced;
        boolean isOriginal = occurrence == this.context.getExpression();
        GrReferenceExpression newExpr = GrIntroduceConstantProcessor.createRefExpression(field, occurrence);
        PsiElement psiElement = replaced = occurrence instanceof GrExpression ? ((GrExpression)occurrence).replaceWithExpression(newExpr, false) : occurrence.replace((PsiElement)newExpr);
        if (escalateVisibility) {
            PsiUtil.escalateVisibility(field, replaced);
        }
        if (replaced instanceof GrReferenceExpression) {
            GrReferenceAdjuster.shortenReference((GrReferenceExpression)replaced);
        }
        if (isOriginal) {
            this.updateCaretPosition(replaced);
        }
        return replaced;
    }

    private static GrReferenceExpression createRefExpression(GrField field, PsiElement place) {
        PsiClass containingClass = field.getContainingClass();
        assert (containingClass != null);
        String qname = containingClass.getQualifiedName();
        String fieldName = field.getName();
        String refText = qname != null && !qname.equals(fieldName) ? qname + "." + fieldName : fieldName;
        return GroovyPsiElementFactory.getInstance(place.getProject()).createReferenceExpressionFromText(refText, place);
    }

    private GrVariableDeclaration createField(PsiClass targetClass) {
        String name = this.settings.getName();
        PsiType type = this.settings.getSelectedType();
        String[] modifiers = this.collectModifiers(targetClass);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.context.getProject());
        return factory.createFieldDeclaration(modifiers, name, this.getInitializer(), type);
    }

    protected GrExpression getInitializer() {
        GrVariable var = GrIntroduceHandlerBase.resolveLocalVar(this.context);
        GrExpression expression = this.context.getExpression();
        if (var != null) {
            return var.getInitializerGroovy();
        }
        if (expression != null) {
            return expression;
        }
        return this.context.getStringPart().createLiteralFromSelected();
    }

    private String[] collectModifiers(PsiClass targetClass) {
        String modifier = this.isEscalateVisibility() ? "private" : this.settings.getVisibilityModifier();
        ArrayList<String> modifiers = new ArrayList<String>();
        if (modifier != null && !"packageLocal".equals(modifier)) {
            modifiers.add(modifier);
        }
        if (!targetClass.isInterface()) {
            modifiers.add("static");
            modifiers.add("final");
        }
        return ArrayUtil.toStringArray(modifiers);
    }

    private boolean isEscalateVisibility() {
        return "EscalateVisible".equals(this.settings.getVisibilityModifier());
    }
}

