/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.ConflictReporter;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;

public class GrIntroduceValidatorEngine
implements GrIntroduceHandlerBase.Validator {
    private final GrIntroduceContext myContext;
    private final ConflictReporter myReporter;

    public GrIntroduceValidatorEngine(GrIntroduceContext context, ConflictReporter reporter) {
        this.myContext = context;
        this.myReporter = reporter;
    }

    @Override
    public boolean isOK(GrIntroduceDialog dialog) {
        boolean allOccurrences;
        Object settings = dialog.getSettings();
        if (settings == null) {
            return false;
        }
        String varName = settings.getName();
        MultiMap<PsiElement, String> conflicts = this.isOKImpl(varName, allOccurrences = settings.replaceAllOccurrences());
        return conflicts.size() <= 0 || GrIntroduceValidatorEngine.reportConflicts(conflicts, this.getProject());
    }

    private static boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project) {
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        return conflictsDialog.showAndGet();
    }

    private MultiMap<PsiElement, String> isOKImpl(String varName, boolean replaceAllOccurrences) {
        PsiElement firstOccurrence = this.getFirstOccurrence(replaceAllOccurrences);
        MultiMap conflicts = new MultiMap();
        assert (varName != null);
        int offset = firstOccurrence.getTextRange().getStartOffset();
        this.validateOccurrencesDown(this.myContext.getScope(), (MultiMap<PsiElement, String>)conflicts, varName, offset);
        if (!(this.myContext.getScope() instanceof GroovyFileBase)) {
            this.validateVariableOccurrencesUp(this.myContext.getScope(), (MultiMap<PsiElement, String>)conflicts, varName, offset);
        }
        if (replaceAllOccurrences) {
            for (PsiElement element : this.myContext.getOccurrences()) {
                if (element == firstOccurrence) continue;
                this.validateVariableOccurrencesUp(element, (MultiMap<PsiElement, String>)conflicts, varName, element.getTextRange().getStartOffset());
            }
        }
        return conflicts;
    }

    private PsiElement getFirstOccurrence(boolean replaceAllOccurrences) {
        if (replaceAllOccurrences) {
            if (this.myContext.getOccurrences().length > 0) {
                GroovyRefactoringUtil.sortOccurrences(this.myContext.getOccurrences());
                return this.myContext.getOccurrences()[0];
            }
            return this.myContext.getPlace();
        }
        GrExpression expression = this.myContext.getExpression();
        return expression != null ? expression : this.myContext.getStringPart().getLiteral();
    }

    public String isOKTest(String varName, boolean allOccurences) {
        MultiMap<PsiElement, String> list = this.isOKImpl(varName, allOccurences);
        String result = "";
        String[] strings = ArrayUtil.toStringArray((Collection)list.values());
        Arrays.sort(strings, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String s : strings) {
            result = result + s.replaceAll("<b><code>", "").replaceAll("</code></b>", "") + "\n";
        }
        if (!list.isEmpty()) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.isEmpty()) {
            result = "ok";
        }
        return result;
    }

    private void validateOccurrencesDown(PsiElement startElement, MultiMap<PsiElement, String> conflicts, String varName, double startOffset) {
        PsiElement child = startElement.getFirstChild();
        while (child != null) {
            if (child instanceof GrTypeDefinition || child instanceof GrMethod || GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(child) && (double)child.getTextRange().getEndOffset() < startOffset) {
                this.myReporter.check(child, conflicts, varName);
                child = child.getNextSibling();
                continue;
            }
            if (child instanceof GrVariable) {
                this.myReporter.check(child, conflicts, varName);
                this.validateOccurrencesDown(child, conflicts, varName, startOffset);
            } else {
                this.validateOccurrencesDown(child, conflicts, varName, startOffset);
            }
            child = child.getNextSibling();
        }
    }

    private void validateVariableOccurrencesUp(PsiElement startElement, MultiMap<PsiElement, String> conflicts, String varName, double startOffset) {
        for (PsiElement prevSibling = startElement.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(prevSibling) && (double)prevSibling.getTextRange().getEndOffset() < startOffset) continue;
            this.validateOccurrencesDown(prevSibling, conflicts, varName, startOffset);
        }
        PsiElement parent = startElement.getParent();
        if (parent == null || parent instanceof GrMethod || parent instanceof GrTypeDefinition || parent instanceof GroovyFileBase || parent instanceof PsiDirectory) {
            return;
        }
        this.validateVariableOccurrencesUp(parent, conflicts, varName, startOffset);
    }

    @Override
    public String validateName(String name, boolean increaseNumber) {
        String result = name;
        if (!this.isOKImpl(name, true).isEmpty() && !increaseNumber || name.isEmpty()) {
            return "";
        }
        int i = 1;
        while (!this.isOKImpl(result, true).isEmpty()) {
            result = name + i;
            ++i;
        }
        return result;
    }

    @Override
    public Project getProject() {
        return this.myContext.getProject();
    }
}

