/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class InitialInfo
implements ExtractInfoHelper {
    private final ParameterInfo[] myParameterInfos;
    private final VariableInfo[] myOutputNames;
    private final PsiType myOutputType;
    private final PsiElement[] myInnerElements;
    private final Project myProject;
    private final GrStatement[] myStatements;
    private final boolean myHasReturnValue;
    private final String[] myArgumentNames;
    private final StringPartInfo myStringPartInfo;
    private final GrVariable myVariable;

    public InitialInfo(VariableInfo[] inputInfos, VariableInfo[] outputInfos, PsiElement[] innerElements, GrStatement[] statements, ArrayList<GrStatement> returnStatements, StringPartInfo stringPartInfo, Project project, GrVariable variable) {
        this.myInnerElements = innerElements;
        this.myStatements = statements;
        this.myOutputNames = outputInfos;
        this.myStringPartInfo = stringPartInfo;
        this.myVariable = variable;
        boolean bl = this.myHasReturnValue = ContainerUtil.find(returnStatements, (Condition)new Condition<GrStatement>(){

            public boolean value(GrStatement statement) {
                return statement instanceof GrReturnStatement && ((GrReturnStatement)statement).getReturnValue() != null;
            }
        }) != null;
        assert (this.myStringPartInfo != null || this.myStatements.length > 0);
        this.myProject = project;
        this.myParameterInfos = new ParameterInfo[inputInfos.length];
        this.myArgumentNames = new String[inputInfos.length];
        for (int i = 0; i < inputInfos.length; ++i) {
            VariableInfo info = inputInfos[i];
            PsiType type = info.getType();
            this.myParameterInfos[i] = new ParameterInfo(info.getName(), i, type);
            this.myArgumentNames[i] = info.getName();
        }
        PsiType outputType = this.inferOutputType(outputInfos, statements, returnStatements, this.myHasReturnValue, stringPartInfo);
        this.myOutputType = outputType != null ? outputType : PsiType.VOID;
    }

    private PsiType inferOutputType(VariableInfo[] outputInfos, GrStatement[] statements, ArrayList<GrStatement> returnStatements, boolean hasReturnValue, StringPartInfo stringPartInfo) {
        if (stringPartInfo != null) {
            return stringPartInfo.getLiteral().getType();
        }
        PsiPrimitiveType outputType = PsiType.VOID;
        if (outputInfos.length > 0) {
            outputType = outputInfos.length == 1 ? outputInfos[0].getType() : JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeFromText("java.util.List", this.getContext());
        } else if (ExtractUtil.isSingleExpression(statements)) {
            outputType = ((GrExpression)statements[0]).getType();
        } else if (hasReturnValue) {
            assert (!returnStatements.isEmpty());
            ArrayList<PsiType> types = new ArrayList<PsiType>(returnStatements.size());
            for (GrStatement statement : returnStatements) {
                if (statement instanceof GrReturnStatement) {
                    GrExpression returnValue = ((GrReturnStatement)statement).getReturnValue();
                    if (returnValue == null) continue;
                    types.add(returnValue.getType());
                    continue;
                }
                if (!(statement instanceof GrExpression)) continue;
                types.add(((GrExpression)statement).getType());
            }
            outputType = TypesUtil.getLeastUpperBoundNullable(types, this.getContext().getManager());
        }
        return outputType;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public ParameterInfo[] getParameterInfos() {
        return this.myParameterInfos;
    }

    @Override
    public VariableInfo[] getOutputVariableInfos() {
        return this.myOutputNames;
    }

    @Override
    public String[] getArgumentNames() {
        return this.myArgumentNames;
    }

    @Override
    public PsiType getOutputType() {
        return this.myOutputType;
    }

    @Override
    public PsiElement[] getInnerElements() {
        return this.myInnerElements;
    }

    @Override
    public GrStatement[] getStatements() {
        return this.myStatements;
    }

    @Override
    public boolean hasReturnValue() {
        return this.myHasReturnValue;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement getContext() {
        return this.myStatements.length > 0 ? this.myStatements[0] : this.myStringPartInfo.getLiteral();
    }

    @Override
    public boolean isForceReturn() {
        return false;
    }

    @Override
    public StringPartInfo getStringPartInfo() {
        return this.myStringPartInfo;
    }

    @Override
    public GrVariable getVar() {
        return this.myVariable;
    }
}

