/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;

public class StubClassNameProvider
implements ClassNameProvider {
    private final Set<VirtualFile> myAllToCompile;

    public StubClassNameProvider(Set<VirtualFile> allToCompile) {
        this.myAllToCompile = allToCompile;
    }

    @Override
    public String getQualifiedClassName(PsiClass psiClass, PsiElement context) {
        PsiClass container;
        if (context != null && psiClass != null) {
            psiClass = GenerationUtil.findAccessibleSuperClass(context, psiClass);
        }
        if (psiClass == null) {
            return "java.lang.Object";
        }
        if (psiClass instanceof GrTypeDefinition && !this.myAllToCompile.contains(psiClass.getContainingFile().getVirtualFile()) && (container = psiClass.getContainingClass()) != null) {
            return this.getQualifiedClassName(container, null) + "$" + psiClass.getName();
        }
        String name = psiClass.getQualifiedName();
        if (name != null) {
            return name;
        }
        return psiClass.getName();
    }

    @Override
    public boolean forStubs() {
        return true;
    }
}

