/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class GrChangeInfoImpl
implements JavaChangeInfo {
    GrMethod method;
    final String newName;
    final CanonicalTypes.Type returnType;
    final String visibilityModifier;
    final List<GrParameterInfo> parameters;
    boolean changeParameters = false;
    private boolean myIsParameterTypesChanged = false;
    private boolean myIsParameterNamesChanged = false;
    private boolean myIsNameChanged = false;
    private boolean myIsVisibilityChanged = false;
    private boolean myIsReturnTypeChanged = false;
    private final boolean myIsRetainVarargs;
    private final boolean myIsArrayToVarargs;
    private final boolean myIsObtainVarargs;
    private final boolean myWasVarargs;
    private final String myOldName;
    private PsiIdentifier myNewNameIdentifier;
    private final PsiExpression[] defaultValues;
    private final boolean myDelegate;
    private final ThrownExceptionInfo[] myThrownExceptions;
    private boolean myExceptionSetChanged;
    private boolean myExceptionSetOrOrderChanged;
    private final String[] myOldParameterNames;
    private final String[] myOldParameterTypes;

    public GrChangeInfoImpl(GrMethod method, String visibilityModifier, CanonicalTypes.Type returnType, String newName, List<GrParameterInfo> parameters, ThrownExceptionInfo[] exceptions, boolean generateDelegate) {
        int i;
        this.method = method;
        this.visibilityModifier = visibilityModifier;
        this.returnType = returnType;
        this.parameters = parameters;
        this.newName = newName;
        this.myDelegate = generateDelegate;
        this.myOldName = method.getName();
        if (!method.getName().equals(newName)) {
            this.myIsNameChanged = true;
        }
        boolean bl = this.myIsVisibilityChanged = visibilityModifier != null && !method.hasModifierProperty(visibilityModifier);
        if (!method.isConstructor()) {
            PsiType oldReturnType = null;
            if (method.getReturnTypeElementGroovy() != null) {
                oldReturnType = method.getReturnType();
            }
            try {
                PsiType newReturnType;
                PsiType psiType = newReturnType = returnType == null ? null : returnType.getType((PsiElement)method, this.getMethod().getManager());
                if (oldReturnType == null && newReturnType != null || oldReturnType != null && !oldReturnType.equals(newReturnType)) {
                    this.myIsReturnTypeChanged = true;
                }
            }
            catch (IncorrectOperationException e) {
                this.myIsReturnTypeChanged = true;
            }
        }
        GrParameter[] params = method.getParameters();
        int oldParameterCount = this.method.getParameters().length;
        this.myOldParameterNames = new String[oldParameterCount];
        this.myOldParameterTypes = new String[oldParameterCount];
        for (i = 0; i < oldParameterCount; ++i) {
            GrParameter param = params[i];
            this.myOldParameterNames[i] = param.getName();
            this.myOldParameterTypes[i] = param.getType().getCanonicalText();
        }
        if (oldParameterCount != this.parameters.size()) {
            this.changeParameters = true;
        } else {
            int parametersSize = parameters.size();
            for (i = 0; i < parametersSize; ++i) {
                GrParameterInfo parameter = parameters.get(i);
                if (parameter.getOldIndex() != i) {
                    this.changeParameters = true;
                    break;
                }
                if (!params[i].getName().equals(parameter.getName())) {
                    this.myIsParameterNamesChanged = true;
                }
                try {
                    PsiType type = parameter.createType(method, method.getManager());
                    PsiType oldType = params[i].getType();
                    if (oldType.equals(type)) continue;
                    this.myIsParameterTypesChanged = true;
                    continue;
                }
                catch (IncorrectOperationException e) {
                    this.myIsParameterTypesChanged = true;
                }
            }
        }
        this.myWasVarargs = method.isVarArgs();
        if (parameters.isEmpty()) {
            this.myIsObtainVarargs = false;
            this.myIsRetainVarargs = false;
            this.myIsArrayToVarargs = false;
        } else {
            PsiType oldTypeForVararg;
            GrParameterInfo lastNewParam = parameters.get(parameters.size() - 1);
            this.myIsObtainVarargs = lastNewParam.isVarargType();
            boolean bl2 = this.myIsRetainVarargs = lastNewParam.getOldIndex() >= 0 && this.myIsObtainVarargs;
            this.myIsArrayToVarargs = this.myIsRetainVarargs ? (oldTypeForVararg = params[lastNewParam.getOldIndex()].getType()) instanceof PsiArrayType && !(oldTypeForVararg instanceof PsiEllipsisType) : false;
        }
        if (this.myIsNameChanged) {
            this.myNewNameIdentifier = StringUtil.isJavaIdentifier((String)newName) ? JavaPsiFacade.getElementFactory((Project)this.getMethod().getProject()).createIdentifier(newName) : this.getMethod().getNameIdentifier();
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        this.defaultValues = new PsiExpression[parameters.size()];
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            JavaParameterInfo info = parameters.get(i2);
            if (info.getOldIndex() >= 0 || info.isVarargType() || info.getDefaultValue() == null) continue;
            try {
                this.defaultValues[i2] = factory.createExpressionFromText(info.getDefaultValue(), (PsiElement)method);
                continue;
            }
            catch (IncorrectOperationException e) {
                // empty catch block
            }
        }
        this.myThrownExceptions = exceptions;
        if (exceptions == null) {
            this.myExceptionSetChanged = false;
            this.myExceptionSetOrOrderChanged = false;
        } else {
            PsiClassType[] thrownTypes = method.getThrowsList().getReferencedTypes();
            if (thrownTypes.length != this.myThrownExceptions.length) {
                this.myExceptionSetChanged = true;
                this.myExceptionSetOrOrderChanged = true;
            } else {
                this.myExceptionSetChanged = false;
                for (int i3 = 0; i3 < this.myThrownExceptions.length; ++i3) {
                    ThrownExceptionInfo info = this.myThrownExceptions[i3];
                    if (info.getOldIndex() < 0 || !thrownTypes[info.getOldIndex()].equals((Object)info.createType((PsiElement)method, method.getManager()))) {
                        this.myExceptionSetChanged = true;
                        this.myExceptionSetOrOrderChanged = true;
                        break;
                    }
                    if (info.getOldIndex() == i3) continue;
                    this.myExceptionSetOrOrderChanged = true;
                }
            }
        }
    }

    public JavaParameterInfo[] getNewParameters() {
        return this.parameters.toArray(new GrParameterInfo[this.parameters.size()]);
    }

    public String getNewVisibility() {
        return this.visibilityModifier;
    }

    public boolean isParameterSetOrOrderChanged() {
        return this.changeParameters;
    }

    public boolean isParameterTypesChanged() {
        return this.myIsParameterTypesChanged;
    }

    public boolean isParameterNamesChanged() {
        return this.myIsParameterNamesChanged;
    }

    public boolean isGenerateDelegate() {
        return this.myDelegate;
    }

    public boolean isNameChanged() {
        return this.myIsNameChanged;
    }

    public boolean isVisibilityChanged() {
        return this.myIsVisibilityChanged;
    }

    public boolean isExceptionSetChanged() {
        return this.myExceptionSetChanged;
    }

    public boolean isExceptionSetOrOrderChanged() {
        return this.myExceptionSetOrOrderChanged;
    }

    public GrMethod getMethod() {
        return this.method;
    }

    public boolean isReturnTypeChanged() {
        return this.myIsReturnTypeChanged;
    }

    public CanonicalTypes.Type getNewReturnType() {
        return this.returnType;
    }

    public String getNewName() {
        return this.newName;
    }

    public Language getLanguage() {
        return GroovyLanguage.INSTANCE;
    }

    public String[] getOldParameterNames() {
        return this.myOldParameterNames;
    }

    public String[] getOldParameterTypes() {
        return this.myOldParameterTypes;
    }

    public ThrownExceptionInfo[] getNewExceptions() {
        return this.myThrownExceptions;
    }

    public boolean isRetainsVarargs() {
        return this.myIsRetainVarargs;
    }

    public boolean isObtainsVarags() {
        return this.myIsObtainVarargs;
    }

    public boolean isArrayToVarargs() {
        return this.myIsArrayToVarargs;
    }

    public PsiIdentifier getNewNameIdentifier() {
        return this.myNewNameIdentifier;
    }

    public String getOldName() {
        return this.myOldName;
    }

    public boolean wasVararg() {
        return this.myWasVarargs;
    }

    public boolean[] toRemoveParm() {
        return new boolean[0];
    }

    public PsiExpression getValue(int i, PsiCallExpression callExpression) {
        if (this.defaultValues[i] != null) {
            return this.defaultValues[i];
        }
        return this.parameters.get(i).getValue(callExpression);
    }

    public void updateMethod(PsiMethod psiMethod) {
        if (psiMethod instanceof GrMethod) {
            this.method = (GrMethod)psiMethod;
        }
    }

    public Collection<PsiMethod> getMethodsToPropagateParameters() {
        return Collections.emptyList();
    }
}

