/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.mvc.GroovySdkForProjectFromSourcesStep;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public abstract class MvcProjectStructureDetector
extends ProjectStructureDetector {
    private final MvcFramework myFramework;
    private final String myDirectoryName;

    public MvcProjectStructureDetector(MvcFramework framework) {
        this.myFramework = framework;
        this.myDirectoryName = this.myFramework.getFrameworkName().toLowerCase() + "-app";
    }

    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(File dir, File[] children, File base, List<DetectedProjectRoot> result) {
        for (File child : children) {
            if (!child.getName().equals(this.myDirectoryName) || !child.isDirectory()) continue;
            result.add(new GroovyMvcProjectRoot(dir));
            return ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
        }
        return ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        GroovySdkForProjectFromSourcesStep groovySdkStep = new GroovySdkForProjectFromSourcesStep(this, builder, projectDescriptor, this.myFramework);
        ModuleWizardStep javaSdkStep = ProjectWizardStepFactory.getInstance().createProjectJdkStep(builder.getContext());
        return Arrays.asList(new ModuleWizardStep[]{javaSdkStep, groovySdkStep});
    }

    private class GroovyMvcProjectRoot
    extends DetectedProjectRoot {
        public GroovyMvcProjectRoot(File dir) {
            super(dir);
        }

        public String getRootTypeName() {
            return MvcProjectStructureDetector.this.myFramework.getDisplayName();
        }

        public boolean canContainRoot(DetectedProjectRoot root) {
            return false;
        }
    }
}

